/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.NoSuchReplicationGroupExistException;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class CheckSourceChannelPacket
extends AbstractGroupNameReplicationPacket<Boolean> {
    private static final long serialVersionUID = 1L;
    private Object _targetUniqueId;
    private boolean _checkExistanceOnly;

    public CheckSourceChannelPacket() {
    }

    public CheckSourceChannelPacket(String groupName, Object targetUniqueId, boolean checkExistanceOnly) {
        super(groupName);
        this._targetUniqueId = targetUniqueId;
        this._checkExistanceOnly = checkExistanceOnly;
    }

    @Override
    public Boolean accept(IIncomingReplicationFacade replicationFacade) {
        try {
            IReplicationSourceGroup sourceGroup = replicationFacade.getReplicationSourceGroup(this.getGroupName());
            if (sourceGroup != null) {
                Object existingTargetUniqueId;
                String channelName = XapExtensions.getInstance().getReplicationUtils().toChannelName(this.getSourceLookupName());
                ReplicationEndpointDetails channelEndpointDetails = sourceGroup.getChannelEndpointDetails(channelName);
                Object object = existingTargetUniqueId = channelEndpointDetails != null ? channelEndpointDetails.getUniqueId() : null;
                if (!this._targetUniqueId.equals(existingTargetUniqueId)) {
                    return false;
                }
                if (this._checkExistanceOnly) {
                    return true;
                }
                return sourceGroup.checkChannelConnected(channelName);
            }
            return false;
        }
        catch (NoSuchReplicationGroupExistException e) {
            return Boolean.FALSE;
        }
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._targetUniqueId = IOUtils.readObject(in);
        this._checkExistanceOnly = in.readBoolean();
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._targetUniqueId);
        out.writeBoolean(this._checkExistanceOnly);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("targetId", this._targetUniqueId);
        textualizer.append("checkExistenceOnly", this._checkExistanceOnly);
    }
}

