/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.ConnectChannelHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.ConnectChannelHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ConnectChannelPacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private RouterStubHolder _routerStubHolder;
    private ConnectChannelHandshakeRequest _channelHandshakeRequest;

    public ConnectChannelPacket() {
    }

    public ConnectChannelPacket(String groupName, RouterStubHolder routerStubHolder, ConnectChannelHandshakeRequest channelHandshakeRequest) {
        super(groupName);
        this._routerStubHolder = routerStubHolder;
        this._channelHandshakeRequest = channelHandshakeRequest;
    }

    @Override
    public Object accept(IIncomingReplicationFacade replicationFacade) {
        IReplicationTargetGroup target = replicationFacade.getReplicationTargetGroup(this.getGroupName());
        ConnectChannelHandshakeResponse connectChannelHandshakeResponse = target.connectChannel(this._routerStubHolder, this._channelHandshakeRequest);
        PlatformLogicalVersion platformLogicalVersion = this._routerStubHolder.getMyEndpointDetails().getPlatformLogicalVersion();
        if (platformLogicalVersion != null) {
            return connectChannelHandshakeResponse;
        }
        return connectChannelHandshakeResponse.getProcessLogHandshakeResponse();
    }

    public ConnectChannelHandshakeRequest getChannelHandshakeRequest() {
        return this._channelHandshakeRequest;
    }

    public RouterStubHolder getRouterStubHolder() {
        return this._routerStubHolder;
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._routerStubHolder = (RouterStubHolder)IOUtils.readObject(in);
        this._channelHandshakeRequest = new ConnectChannelHandshakeRequest();
        this._channelHandshakeRequest.readExternal(in);
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._routerStubHolder);
        this._channelHandshakeRequest.writeExternal(out);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("handshakeRequest", this._channelHandshakeRequest);
    }
}

