/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class HandleDataConsumeErrorPacket
extends AbstractGroupNameReplicationPacket<IDataConsumeFix> {
    private static final long serialVersionUID = 1L;
    private IDataConsumeResult _errorResult;
    private long _errorDataPacketKey;

    public HandleDataConsumeErrorPacket() {
    }

    public HandleDataConsumeErrorPacket(IDataConsumeResult errorResult, String groupName, long errorDataPacketKey) {
        super(groupName);
        this._errorResult = errorResult;
        this._errorDataPacketKey = errorDataPacketKey;
    }

    @Override
    public IDataConsumeFix accept(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationOrderedPacket packet;
        IReplicationSourceGroup sourceGroup = incomingReplicationFacade.getReplicationSourceGroup(this.getGroupName());
        IReplicationGroupBacklog backlog = sourceGroup.getGroupBacklog();
        IReplicationPacketData<?> errorData = null;
        if (this._errorDataPacketKey != -1L && (packet = backlog.getSpecificPacket(this._errorDataPacketKey)) != null) {
            errorData = packet.getData();
        }
        return backlog.getDataProducer().createFix(this._errorResult, errorData);
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._errorResult = (IDataConsumeResult)IOUtils.readObject(in);
        this._errorDataPacketKey = in.readLong();
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._errorResult);
        out.writeLong(this._errorDataPacketKey);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("errorResult", this._errorResult);
        textualizer.append("errorPacketKey", this._errorDataPacketKey);
    }
}

