/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class IdleStateDataReplicatedPacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private IIdleStateData _idleStateData;

    public IdleStateDataReplicatedPacket() {
    }

    public IdleStateDataReplicatedPacket(String groupName, IIdleStateData idleStateData) {
        super(groupName);
        this._idleStateData = idleStateData;
    }

    public IdleStateDataReplicatedPacket(String groupName) {
        this(groupName, null);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._idleStateData);
    }

    @Override
    protected void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._idleStateData = (IIdleStateData)IOUtils.readObject(in);
    }

    @Override
    public Object accept(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationTargetGroup targetGroup = incomingReplicationFacade.getReplicationTargetGroup(this.getGroupName());
        return targetGroup.processIdleStateData(this.getSourceLookupName(), this.getSourceUniqueId(), this._idleStateData);
    }

    public IIdleStateData getIdleStateData() {
        return this._idleStateData;
    }

    public void clean() {
        this._idleStateData = null;
    }

    public void setIdleStateData(IIdleStateData idleStateData) {
        this._idleStateData = idleStateData;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("idleStateData", this._idleStateData);
    }
}

