/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.CurrentStageInfo;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class NextReplicaStatePacket
extends AbstractReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private Object _replicaRemoteContext;

    public NextReplicaStatePacket() {
    }

    public NextReplicaStatePacket(Object replicaRemoteContext) {
        this._replicaRemoteContext = replicaRemoteContext;
    }

    @Override
    public Object accept(IIncomingReplicationFacade incomingReplicationFacade) {
        CurrentStageInfo currentReplicaStage = incomingReplicationFacade.nextReplicaStage(this._replicaRemoteContext);
        PlatformLogicalVersion sourceLogicalVersion = this.getSourceEndpointDetails().getPlatformLogicalVersion();
        if (sourceLogicalVersion != null) {
            return currentReplicaStage;
        }
        return !currentReplicaStage.isLastStage();
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._replicaRemoteContext = IOUtils.readObject(in);
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._replicaRemoteContext);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("context", this._replicaRemoteContext);
    }
}

