/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetChannel;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IReplicationReliableAsyncMediator;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncKeeperTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ReliableAsyncStateUpdatePacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private IReliableAsyncState _reliableAsyncState;

    public ReliableAsyncStateUpdatePacket() {
    }

    public ReliableAsyncStateUpdatePacket(String groupName) {
        super(groupName);
    }

    @Override
    public Object accept(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationTargetGroup replicationTargetGroup = incomingReplicationFacade.getReplicationTargetGroup(this.getGroupName());
        IReplicationTargetChannel targetChannel = replicationTargetGroup.getChannel(this.getSourceLookupName());
        IReplicationReliableAsyncKeeperTargetProcessLog processLog = (IReplicationReliableAsyncKeeperTargetProcessLog)((Object)targetChannel.getProcessLog());
        IReplicationReliableAsyncMediator mediator = processLog.getMediator();
        mediator.updateReliableAsyncState(this._reliableAsyncState, this.getSourceLookupName());
        return null;
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._reliableAsyncState = (IReliableAsyncState)IOUtils.readObject(in);
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._reliableAsyncState);
    }

    public void setState(IReliableAsyncState reliableAsyncState) {
        this._reliableAsyncState = reliableAsyncState;
    }
}

