/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

@InternalApi
public class ReplicaFetchDataPacket
extends AbstractReplicationPacket<Collection<ISpaceReplicaData>> {
    private static final long serialVersionUID = 1L;
    private Object _replicaRemoteContext;
    private int _fetchBatchSize;

    public ReplicaFetchDataPacket() {
    }

    public ReplicaFetchDataPacket(Object replicaRemoteContext, int fetchBatchSize) {
        this._replicaRemoteContext = replicaRemoteContext;
        this._fetchBatchSize = fetchBatchSize;
    }

    @Override
    public Collection<ISpaceReplicaData> accept(IIncomingReplicationFacade incomingReplicationFacade) {
        return incomingReplicationFacade.getNextReplicaBatch(this._replicaRemoteContext, this._fetchBatchSize);
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._replicaRemoteContext = in.readObject();
        this._fetchBatchSize = in.readInt();
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        out.writeObject(this._replicaRemoteContext);
        out.writeInt(this._fetchBatchSize);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("context", this._replicaRemoteContext);
        textualizer.append("batchSize", this._fetchBatchSize);
    }
}

