/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaParameters;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ReplicaRequestPacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private ISpaceCopyReplicaParameters _parameters;

    public ReplicaRequestPacket() {
    }

    public ReplicaRequestPacket(String syncGroupName, ISpaceCopyReplicaParameters parameters) {
        super(syncGroupName);
        this._parameters = parameters;
    }

    @Override
    public Object accept(IIncomingReplicationFacade incomingReplicationFacade) {
        return incomingReplicationFacade.newReplicaRequest(this.getSourceLookupName(), this);
    }

    public boolean isSynchronizeRequest() {
        return this.getGroupName() != null;
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._parameters = (ISpaceCopyReplicaParameters)IOUtils.readObject(in);
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._parameters);
    }

    public ISpaceCopyReplicaParameters getParameters() {
        return this._parameters;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.appendNewLine("parameters", this._parameters);
    }
}

