/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ReplicatedDataPacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private IReplicationOrderedPacket _packet;
    private transient boolean _clean = true;

    public ReplicatedDataPacket() {
    }

    public ReplicatedDataPacket(String groupName) {
        super(groupName);
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._packet);
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._packet = (IReplicationOrderedPacket)IOUtils.readObject(in);
    }

    @Override
    public Object accept(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationTargetGroup targetGroup = incomingReplicationFacade.getReplicationTargetGroup(this.getGroupName());
        return targetGroup.process(this.getSourceLookupName(), this.getSourceUniqueId(), this._packet);
    }

    public IReplicationOrderedPacket getPacket() {
        return this._packet;
    }

    public void setPacket(IReplicationOrderedPacket packet) {
        if (!this._clean) {
            throw new IllegalStateException("Attempt to override packet when it was not released");
        }
        this._packet = packet;
        this._clean = false;
    }

    public void clean() {
        this._clean = true;
        this._packet = null;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("packet", this._packet);
    }
}

