/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractGroupNameReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class UnreliableOperationPacket
extends AbstractGroupNameReplicationPacket<Object> {
    private static final long serialVersionUID = 1L;
    private IReplicationUnreliableOperation _operation;

    public UnreliableOperationPacket() {
    }

    public UnreliableOperationPacket(String groupName, IReplicationUnreliableOperation operation) {
        super(groupName);
        this._operation = operation;
    }

    @Override
    public void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion endpointLogicalVersion) throws IOException {
        IOUtils.writeObject(out, this._operation);
    }

    @Override
    public void readExternalImpl(ObjectInput in, PlatformLogicalVersion endpointLogicalVersion) throws IOException, ClassNotFoundException {
        this._operation = (IReplicationUnreliableOperation)IOUtils.readObject(in);
    }

    @Override
    public Object accept(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationTargetGroup targetGroup = incomingReplicationFacade.getReplicationTargetGroup(this.getGroupName());
        targetGroup.processUnreliableOperation(this.getSourceLookupName(), this.getSourceUniqueId(), this._operation);
        return null;
    }

    public IReplicationUnreliableOperation getOperation() {
        return this._operation;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("operation", this._operation);
    }
}

