/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationBlobstoreBulkContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFixFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BlobstoreReplicationPacketDataConsumer
extends ReplicationPacketDataConsumer {
    private static final String LOG_PREFIX = "[BlobstoreReplicationConsumer]";

    public BlobstoreReplicationPacketDataConsumer(SpaceTypeManager typeManager, IDataConsumeFixFacade fixFacade, ReplicationPacketDataMediator packetDataMediator) {
        super(typeManager, fixFacade, packetDataMediator);
    }

    @Override
    public IDataConsumeResult consume(IReplicationInContext context, IExecutableReplicationPacketData<?> data, IReplicationInFacade replicationInFacade, IReplicationInFilterCallback inFilterCallback) {
        replicationInFacade.beforeConsume(context);
        this.prepareBlobstoreBulkIfNeeded(context, data);
        return super.consume(context, data, replicationInFacade, inFilterCallback);
    }

    private void prepareBlobstoreBulkIfNeeded(IReplicationInContext context, IExecutableReplicationPacketData<?> data) {
        if (data.isPartOfBlobstoreBulk()) {
            AbstractReplicationPacketSingleEntryData singleEntryData = (AbstractReplicationPacketSingleEntryData)data;
            this.handleBulkEntryArrived(context, singleEntryData);
        } else {
            this.handleNonBulkEntryArrived(context, data);
        }
    }

    private void handleBulkEntryArrived(IReplicationInContext context, AbstractReplicationPacketSingleEntryData singleEntryData) {
        this.logBulkEntryArrived(context, singleEntryData, Level.FINEST);
        if (!this.initReplicationBulkContextIfNeeded(context, singleEntryData.getBlobstoreBulkId())) {
            context.getReplicationBlobstoreBulkContext().setBulkReplicationInfo(singleEntryData.getBlobstoreBulkId());
        }
    }

    private void handleNonBulkEntryArrived(IReplicationInContext context, IExecutableReplicationPacketData singleEntryData) {
        this.logNonBulkEntryArrived(context, singleEntryData, Level.FINEST);
        this.initReplicationBulkContextIfNeeded(context, 0);
        context.getReplicationBlobstoreBulkContext().nonBulkArrived();
    }

    private boolean initReplicationBulkContextIfNeeded(IReplicationInContext context, int bulkId) {
        if (context.getReplicationBlobstoreBulkContext() == null) {
            ReplicationBlobstoreBulkContext bulkContext = new ReplicationBlobstoreBulkContext(bulkId);
            context.setReplicationBlobstoreBulkContext(bulkContext);
            return true;
        }
        return false;
    }

    private void logNonBulkEntryArrived(IReplicationInContext context, IExecutableReplicationPacketData singleEntryData, Level level) {
        Logger contextLogger = context.getContextLogger();
        ReplicationBlobstoreBulkContext replicationBlobstoreBulkContext = context.getReplicationBlobstoreBulkContext();
        if (contextLogger != null && contextLogger.isLoggable(level)) {
            String uid = "multiUid";
            if (singleEntryData.isSingleEntryData()) {
                uid = singleEntryData.getSingleEntryData().getUid();
            }
            if (replicationBlobstoreBulkContext != null) {
                contextLogger.log(level, "[BlobstoreReplicationConsumer] handling incoming non blobstore bulk entry with uid [" + uid + "], will ask to flush the previous bulk with id [" + replicationBlobstoreBulkContext.getBulkId() + "], thread=" + Thread.currentThread().getName() + ", packetKey=" + context.getLastProcessedKey());
            } else {
                contextLogger.log(level, "[BlobstoreReplicationConsumer] handling incoming non blobstore bulk entry with uid [" + uid + "], the previous entry was not a part of a blobstore bulk, thread=" + Thread.currentThread().getName() + ", packetKey=" + context.getLastProcessedKey());
            }
        }
    }

    private void logBulkEntryArrived(IReplicationInContext context, AbstractReplicationPacketSingleEntryData singleEntryData, Level level) {
        Logger contextLogger = context.getContextLogger();
        ReplicationBlobstoreBulkContext bulkContext = context.getReplicationBlobstoreBulkContext();
        if (contextLogger != null && contextLogger.isLoggable(level)) {
            if (bulkContext == null) {
                contextLogger.log(level, "[BlobstoreReplicationConsumer] handling first incoming blobstore bulk with id [" + singleEntryData.getBlobstoreBulkId() + "], entry uid=" + singleEntryData.getUid() + ", operation type=" + (Object)((Object)singleEntryData.getOperationType()) + ", thread=" + Thread.currentThread().getName() + ", packetKey=" + context.getLastProcessedKey());
            } else {
                contextLogger.log(level, "[BlobstoreReplicationConsumer] handling incoming ongoing blobstore bulk with id [" + singleEntryData.getBlobstoreBulkId() + "], entry uid=" + singleEntryData.getUid() + ", operation type=" + (Object)((Object)singleEntryData.getOperationType()) + ", thread=" + Thread.currentThread().getName() + ", packetKey=" + context.getLastProcessedKey());
            }
        }
    }
}

