/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;

@InternalApi
public class ReplicationEntryDataConversionMetadata
implements Cloneable {
    private IEntryData _entryData;
    private boolean _requiresFullEntryData;
    private boolean _requiresReliableAsyncFullContent;
    private boolean _requiresPrevValue;
    private boolean wasModifiedByFilter;
    private ReplicationSingleOperationType _operationType;
    private QueryResultTypeInternal _requiredResultType = QueryResultTypeInternal.NOT_SET;
    private AbstractProjectionTemplate _projectionTemplate;
    private short _flags;

    public ReplicationEntryDataConversionMetadata() {
    }

    public ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType operationType) {
        this._operationType = operationType;
    }

    protected void onModify() {
    }

    public ReplicationEntryDataConversionMetadata entryData(IEntryData entryData) {
        this.onModify();
        this._entryData = entryData;
        return this;
    }

    public ReplicationEntryDataConversionMetadata requiresFullEntryData() {
        this.onModify();
        this._requiresFullEntryData = true;
        return this;
    }

    public ReplicationEntryDataConversionMetadata requiresReliableAsyncFullContent() {
        this.onModify();
        this._requiresReliableAsyncFullContent = true;
        return this;
    }

    public ReplicationEntryDataConversionMetadata requiresPrevValue() {
        this.onModify();
        this._requiresPrevValue = true;
        return this;
    }

    public ReplicationEntryDataConversionMetadata modifiedByFilter() {
        this.onModify();
        this.wasModifiedByFilter = true;
        return this;
    }

    public ReplicationEntryDataConversionMetadata flags(short flags) {
        this.onModify();
        this._flags = flags;
        return this;
    }

    public ReplicationEntryDataConversionMetadata resultType(QueryResultTypeInternal resultType) {
        this.onModify();
        this._requiredResultType = resultType;
        return this;
    }

    public ReplicationEntryDataConversionMetadata projectionTemplate(AbstractProjectionTemplate projectionTemplate) {
        this.onModify();
        this._projectionTemplate = projectionTemplate;
        return this;
    }

    public IEntryData getEntryData() {
        return this._entryData;
    }

    public short getFlags() {
        return this._flags;
    }

    public boolean isRequiresFullEntryData() {
        return this._requiresFullEntryData;
    }

    public ReplicationSingleOperationType getConvertToOperationType() {
        return this._operationType;
    }

    public boolean isRequiresReliableAsyncFullContent() {
        return this._requiresReliableAsyncFullContent;
    }

    public boolean isRequiresPrevValue() {
        return this._requiresPrevValue;
    }

    public boolean isSameOperationConversion() {
        return this._operationType == null;
    }

    public boolean isModifiedByFilter() {
        return this.wasModifiedByFilter;
    }

    public QueryResultTypeInternal getRequiredQueryResultType() {
        return this._requiredResultType;
    }

    public AbstractProjectionTemplate getProjectionTemplate() {
        return this._projectionTemplate;
    }

    public ReplicationEntryDataConversionMetadata clone() {
        try {
            return (ReplicationEntryDataConversionMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return "ReplicationEntryDataConversionMetadata [requiresFullEntryData()=" + this.requiresFullEntryData() + ", requiresReliableAsyncFullContent()=" + this.requiresReliableAsyncFullContent() + ", getEntryData()=" + this.getEntryData() + ", getFlags()=" + this.getFlags() + ", isRequiresFullEntryData()=" + this.isRequiresFullEntryData() + ", getConvertToOperationType()=" + (Object)((Object)this.getConvertToOperationType()) + ", isRequiresReliableAsyncFullContent()=" + this.isRequiresReliableAsyncFullContent() + ", isSameOperationConversion()=" + this.isSameOperationConversion() + ", getRequiredQueryResultType()=" + (Object)((Object)this.getRequiredQueryResultType()) + ", getProjectionTemplate()=" + this.getProjectionTemplate() + "]";
    }
}

