/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.handlers.UnknownEntryLeaseException;
import com.gigaspaces.internal.cluster.node.impl.handlers.UnknownNotifyTemplateLeaseException;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.DataConsumeOkResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFixFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationParticipantsMetadata;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.SingleParticipantMetadata;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnknownConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnknownEntryLeaseConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnknownNotifyTemplateLeaseConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnknownTransactionConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnknownTypeConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionOnePhaseReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionReplicationPacketData;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.transaction.TransactionUniqueId;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationFilterException;
import com.j_spaces.core.exception.ClosedResourceException;
import com.j_spaces.core.exception.SpaceUnavailableException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

@InternalApi
public class ReplicationPacketDataConsumer
implements IReplicationPacketDataBatchConsumer<IExecutableReplicationPacketData<?>> {
    private final IDataConsumeFixFacade _fixFacade;
    private final SpaceTypeManager _typeManager;
    private final ReplicationPacketDataMediator _packetDataMediator;

    public ReplicationPacketDataConsumer(SpaceTypeManager typeManager, IDataConsumeFixFacade fixFacade, ReplicationPacketDataMediator packetDataMediator) {
        this._typeManager = typeManager;
        this._fixFacade = fixFacade;
        this._packetDataMediator = packetDataMediator;
    }

    @Override
    public IDataConsumeResult consume(IReplicationInContext context, IExecutableReplicationPacketData<?> data, IReplicationInFacade replicationInFacade, IReplicationInFilterCallback inFilterCallback) {
        try {
            if (inFilterCallback != null) {
                inFilterCallback.invokeInFilter(context, data);
                if (data.isEmpty()) {
                    return DataConsumeOkResult.OK;
                }
            }
            data.execute(context, replicationInFacade, this._packetDataMediator);
            return DataConsumeOkResult.OK;
        }
        catch (ReplicationFilterException filterEx) {
            Throwable cause = filterEx.getCause();
            return this.createErrorResult(cause != null ? cause : filterEx, context);
        }
        catch (Throwable e) {
            return this.createErrorResult(e, context);
        }
    }

    private AbstractDataConsumeErrorResult createErrorResult(Throwable e, IReplicationInContext context) {
        if (context.getContextLogger().isLoggable(Level.FINEST)) {
            context.getContextLogger().finest("received error result when consuming incoming replication [" + e + "], creating corresponding error result");
        }
        if (e instanceof UnknownTypeException) {
            return new UnknownTypeConsumeResult(((UnknownTypeException)e).getUnknownClassName(), (UnknownTypeException)e);
        }
        if (e instanceof UnknownEntryLeaseException) {
            UnknownEntryLeaseException unknownLeaseException = (UnknownEntryLeaseException)e;
            return new UnknownEntryLeaseConsumeResult(unknownLeaseException.getClassName(), unknownLeaseException.getUID(), unknownLeaseException.getOperationID(), (UnknownEntryLeaseException)e);
        }
        if (e instanceof UnknownNotifyTemplateLeaseException) {
            UnknownNotifyTemplateLeaseException unknownLeaseException = (UnknownNotifyTemplateLeaseException)e;
            return new UnknownNotifyTemplateLeaseConsumeResult(unknownLeaseException.getClassName(), unknownLeaseException.getUID(), (UnknownNotifyTemplateLeaseException)e);
        }
        if (e instanceof SpaceUnavailableException) {
            throw new ClosedResourceException(e.getMessage(), e);
        }
        if (e instanceof UnknownTransactionException) {
            return new UnknownTransactionConsumeResult((UnknownTransactionException)e);
        }
        return new UnknownConsumeErrorResult(e);
    }

    @Override
    public IExecutableReplicationPacketData<?> applyFix(IReplicationInContext context, IExecutableReplicationPacketData<?> data, IDataConsumeFix fix) throws Exception {
        if (fix instanceof AbstractDataConsumeFix) {
            if (context.getContextLogger().isLoggable(Level.FINEST)) {
                context.getContextLogger().finest("applying fix [" + fix.getClass().getName() + "], due previous to consumption error");
            }
            return ((AbstractDataConsumeFix)fix).fix(context, this._fixFacade, this, data);
        }
        throw new UnsupportedOperationException("Unsupported consumer fix - " + fix);
    }

    @Override
    public Iterable<IReplicationFilterEntry> toFilterEntries(IReplicationInContext context, IReplicationPacketData<?> data) {
        IExecutableReplicationPacketData executableData = (IExecutableReplicationPacketData)data;
        return executableData.toFilterEntries(this._typeManager);
    }

    @Override
    public IReplicationParticipantsMetadata extractParticipantsMetadata(IReplicationPacketData<?> data) {
        LinkedList typedData;
        if (data instanceof AbstractTransactionReplicationPacketData && ((AbstractTransactionReplicationPacketData)(typedData = (AbstractTransactionReplicationPacketData)data)).getMetaData() != null) {
            return ((AbstractTransactionReplicationPacketData)typedData).getMetaData();
        }
        if (data instanceof TransactionReplicationPacketData && ((TransactionReplicationPacketData)(typedData = (TransactionReplicationPacketData)data)).getMetaData() != null) {
            return ((TransactionReplicationPacketData)typedData).getMetaData();
        }
        return SingleParticipantMetadata.INSTANCE;
    }

    @Override
    public IReplicationPacketData<?> merge(IReplicationPacketData<?>[] allParticipantsData, IReplicationParticipantsMetadata participantsMetadata) {
        TransactionOnePhaseReplicationPacketData mergedData = new TransactionOnePhaseReplicationPacketData();
        TransactionParticipantDataImpl transactionParticipantData = new TransactionParticipantDataImpl((TransactionUniqueId)participantsMetadata.getContextId(), -1, participantsMetadata.getTransactionParticipantsCount());
        Iterator[] iterators = new Iterator[allParticipantsData.length];
        IReplicationPacketEntryData[] pendingDataPerParticipant = new IReplicationPacketEntryData[allParticipantsData.length];
        int listsToMerge = 0;
        for (int i = 0; i < iterators.length; ++i) {
            iterators[i] = allParticipantsData[i].iterator();
            if (!iterators[i].hasNext()) continue;
            pendingDataPerParticipant[i] = (IReplicationPacketEntryData)iterators[i].next();
            ++listsToMerge;
        }
        while (listsToMerge > 0) {
            int index;
            for (index = 0; index < iterators.length && pendingDataPerParticipant[index] == null; ++index) {
            }
            int minimumOperationIdIndex = index++;
            while (index < iterators.length) {
                if (pendingDataPerParticipant[index] != null && pendingDataPerParticipant[index].getOperationId().getOperationID() < pendingDataPerParticipant[minimumOperationIdIndex].getOperationId().getOperationID()) {
                    minimumOperationIdIndex = index;
                }
                ++index;
            }
            mergedData.add((IReplicationTransactionalPacketEntryData)pendingDataPerParticipant[minimumOperationIdIndex]);
            if (iterators[minimumOperationIdIndex].hasNext()) {
                pendingDataPerParticipant[minimumOperationIdIndex] = (IReplicationPacketEntryData)iterators[minimumOperationIdIndex].next();
                continue;
            }
            pendingDataPerParticipant[minimumOperationIdIndex] = null;
            --listsToMerge;
        }
        mergedData.setMetaData(transactionParticipantData);
        return mergedData;
    }

    @Override
    public IDataConsumeResult consumePendingPackets(IReplicationInBatchContext context, IReplicationInFacade replicationInFacade) {
        try {
            replicationInFacade.consumePendingOperationsInBatch(context);
            return DataConsumeOkResult.OK;
        }
        catch (Throwable e) {
            return this.createErrorResult(e, context);
        }
    }

    @Override
    public SpaceTypeManager getTypeManager() {
        return this._typeManager;
    }
}

