/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.notification.NotificationReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationEntryDataConversionMetadata;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketEntryDataConversionException;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.CancelLeaseFullReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.ChangeReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.EntryLeaseExpiredFullReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.PartialUpdateReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.RemoveByUIDReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.RemoveReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.UpdateReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.WriteReplicationPacketData;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.version.PlatformLogicalVersion;

@InternalApi
public class ReplicationPacketDataConverter {
    public static AbstractReplicationPacketSingleEntryData convert(IReplicationPacketEntryData entryData, ReplicationEntryDataConversionMetadata metadata, PlatformLogicalVersion targetMemberVersion) throws ReplicationPacketEntryDataConversionException {
        boolean noConversionApplied;
        IReplicationPacketEntryData result = null;
        switch (entryData.getOperationType()) {
            case UPDATE: {
                UpdateReplicationPacketData updateOperation = (UpdateReplicationPacketData)entryData;
                if (metadata.isRequiresPrevValue()) {
                    updateOperation.serializeFullContent();
                }
                if (metadata.isRequiresReliableAsyncFullContent() && metadata.getConvertToOperationType() == ReplicationSingleOperationType.UPDATE) {
                    ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                    result = ReplicationPacketDataConverter.convertFromUpdateToUpdateReliableAsyncContentRequired(updateOperation);
                }
                if (metadata.getConvertToOperationType() == ReplicationSingleOperationType.UPDATE && metadata.getEntryData() != null) {
                    ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                    result = ReplicationPacketDataConverter.convertFromUpdateToUpdateWithEntryData(updateOperation, metadata);
                }
                if (metadata.getConvertToOperationType() == ReplicationSingleOperationType.UPDATE && metadata.isRequiresFullEntryData() && metadata.getEntryData() == null && !entryData.containsFullEntryData()) {
                    ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                    result = ReplicationPacketDataConverter.convertFromUpdateToUpdateFullContentRequiredNoEntryData(updateOperation, metadata);
                }
                if (metadata.getConvertToOperationType() == ReplicationSingleOperationType.REMOVE_ENTRY && !metadata.isRequiresFullEntryData() && metadata.getEntryData() == null) {
                    ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                    result = ReplicationPacketDataConverter.convertFromUpdateToRemoveNoFullContentRequiredNoEntryData(updateOperation);
                }
                if (metadata.getConvertToOperationType() != ReplicationSingleOperationType.WRITE || metadata.getEntryData() != null) break;
                ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                result = ReplicationPacketDataConverter.convertFromUpdateToWriteNoEntryData(updateOperation);
                break;
            }
            case CHANGE: {
                ChangeReplicationPacketData changeOperation = (ChangeReplicationPacketData)entryData;
                if (metadata.getConvertToOperationType() == ReplicationSingleOperationType.UPDATE) {
                    ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, result);
                    result = metadata.isRequiresReliableAsyncFullContent() ? ReplicationPacketDataConverter.convertFromChangeToUpdateReliableAsyncContentRequired(changeOperation, metadata) : ReplicationPacketDataConverter.convertFromChangeToUpdate(changeOperation, metadata);
                }
                if (metadata.getConvertToOperationType() == ReplicationSingleOperationType.REMOVE_ENTRY && !metadata.isRequiresFullEntryData()) {
                    ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                    result = ReplicationPacketDataConverter.convertFromChangeToRemoveNoFullContentRequired(changeOperation);
                }
                if (metadata.getConvertToOperationType() != ReplicationSingleOperationType.WRITE) break;
                ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                result = ReplicationPacketDataConverter.convertFromChangeToWrite(changeOperation, metadata);
                break;
            }
            case WRITE: {
                WriteReplicationPacketData writeOperation = (WriteReplicationPacketData)entryData;
                if (metadata.getConvertToOperationType() != ReplicationSingleOperationType.WRITE || metadata.getEntryData() == null) break;
                ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, result);
                result = ReplicationPacketDataConverter.convertFromWriteToWriteNoFullContentRequiredWithEntryData(writeOperation, metadata);
                break;
            }
            case REMOVE_ENTRY: {
                if (metadata.getConvertToOperationType() != ReplicationSingleOperationType.REMOVE_ENTRY || !metadata.isRequiresFullEntryData()) break;
                ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, result);
                result = ReplicationPacketDataConverter.convertFromRemoveToRemoveFullContentRequired(entryData, metadata);
                break;
            }
            case CANCEL_LEASE: {
                if (metadata.getConvertToOperationType() == ReplicationSingleOperationType.ENTRY_LEASE_EXPIRED && metadata.isRequiresFullEntryData()) {
                    ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, result);
                    result = ReplicationPacketDataConverter.convertFromLeaseOperationToLeaseExpiredFullContentRequired(entryData, metadata);
                }
                if (metadata.getConvertToOperationType() != ReplicationSingleOperationType.CANCEL_LEASE || !metadata.isRequiresFullEntryData()) break;
                ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, (AbstractReplicationPacketSingleEntryData)result);
                result = ReplicationPacketDataConverter.convertFromLeaseCancelledToLeaseCancelledFullContentRequired(entryData);
                break;
            }
            case ENTRY_LEASE_EXPIRED: {
                if (metadata.getConvertToOperationType() != ReplicationSingleOperationType.ENTRY_LEASE_EXPIRED || !metadata.isRequiresFullEntryData()) break;
                ReplicationPacketDataConverter.validateNonCascadingConversion(entryData, result);
                result = ReplicationPacketDataConverter.convertFromLeaseOperationToLeaseExpiredFullContentRequired(entryData, metadata);
            }
        }
        boolean bl = noConversionApplied = result == null || result == entryData;
        if (noConversionApplied && entryData.containsFullEntryData() && entryData instanceof SingleReplicationPacketData && metadata.getRequiredQueryResultType() != QueryResultTypeInternal.NOT_SET) {
            SingleReplicationPacketData packetData = (SingleReplicationPacketData)entryData;
            if (metadata.getRequiredQueryResultType().isPbs() && packetData.getEntryPacket().getPacketType() != TransportPacketType.PBS) {
                IEntryPacket convertedPacket = EntryPacketFactory.createFullPacket(packetData.getMainEntryData(), entryData.getOperationId(), entryData.getUid(), entryData.isTransient(), metadata.getRequiredQueryResultType());
                result = packetData.cloneWithEntryPacket(convertedPacket);
            } else {
                result = packetData;
            }
        }
        if (metadata.getProjectionTemplate() != null) {
            IReplicationPacketEntryData returnedEntryData;
            IReplicationPacketEntryData iReplicationPacketEntryData = returnedEntryData = result != null ? result : entryData;
            if (returnedEntryData instanceof SingleReplicationPacketData) {
                SingleReplicationPacketData returnedPacketEntryData = (SingleReplicationPacketData)returnedEntryData;
                SingleReplicationPacketData originalPacketData = (SingleReplicationPacketData)(entryData instanceof SingleReplicationPacketData ? entryData : null);
                boolean cloneEntryPacketRequired = originalPacketData == null ? false : returnedPacketEntryData.getEntryPacket() == originalPacketData.getEntryPacket();
                IEntryPacket entryPacket = cloneEntryPacketRequired ? returnedPacketEntryData.getEntryPacket().clone() : returnedPacketEntryData.getEntryPacket();
                metadata.getProjectionTemplate().filterOutNonProjectionProperties(entryPacket);
                if (returnedPacketEntryData instanceof UpdateReplicationPacketData && !NotificationReplicationChannelDataFilter.DurableNotificationConversionFlags.isUpdateToUnmatched(metadata.getFlags())) {
                    UpdateReplicationPacketData updateReplicationPacketData = (UpdateReplicationPacketData)returnedPacketEntryData;
                    IEntryData prevEntryData = updateReplicationPacketData.getSecondaryEntryData();
                    metadata.getProjectionTemplate().filterOutNonProjectionProperties(prevEntryData);
                }
                if (cloneEntryPacketRequired) {
                    result = returnedPacketEntryData.cloneWithEntryPacket(entryPacket);
                }
            }
        }
        if (result != null) {
            return result;
        }
        throw new ReplicationPacketEntryDataConversionException("Cannot convert [" + entryData + "] to [" + metadata + "]");
    }

    private static UpdateReplicationPacketData convertFromChangeToUpdateReliableAsyncContentRequired(ChangeReplicationPacketData changeOperation, ReplicationEntryDataConversionMetadata metadata) {
        UpdateReplicationPacketData updateReplicationPacketData = ReplicationPacketDataConverter.convertFromChangeToUpdate(changeOperation, metadata);
        updateReplicationPacketData.serializeFullContent();
        return updateReplicationPacketData;
    }

    private static UpdateReplicationPacketData convertFromChangeToUpdate(ChangeReplicationPacketData changeOperation, ReplicationEntryDataConversionMetadata metadata) {
        IEntryData entryData = metadata.getEntryData() != null ? metadata.getEntryData() : changeOperation.getMainEntryData();
        IEntryPacket fullPacket = EntryPacketFactory.createFullPacket(entryData, changeOperation.getOperationId(), changeOperation.getUid(), changeOperation.isTransient(), metadata.getRequiredQueryResultType());
        UpdateReplicationPacketData updateReplicationPacketData = new UpdateReplicationPacketData(fullPacket, changeOperation.isFromGateway(), false, changeOperation.getSecondaryEntryData(), metadata.getFlags(), changeOperation.getExpirationTime(), entryData);
        updateReplicationPacketData.serializeFullContent();
        return updateReplicationPacketData;
    }

    private static RemoveByUIDReplicationPacketData convertFromChangeToRemoveNoFullContentRequired(ChangeReplicationPacketData changeOperation) {
        return new RemoveByUIDReplicationPacketData(changeOperation.getTypeName(), changeOperation.getUid(), changeOperation.isTransient(), changeOperation.getMainEntryData(), changeOperation.getOperationId(), changeOperation.isFromGateway());
    }

    private static WriteReplicationPacketData convertFromChangeToWrite(ChangeReplicationPacketData changeOperation, ReplicationEntryDataConversionMetadata metadata) {
        IEntryData entryData = metadata.getEntryData() != null ? metadata.getEntryData() : changeOperation.getMainEntryData();
        IEntryPacket fullPacket = EntryPacketFactory.createFullPacket(entryData, changeOperation.getOperationId(), changeOperation.getUid(), changeOperation.isTransient(), metadata.getRequiredQueryResultType());
        return new WriteReplicationPacketData(fullPacket, changeOperation.isFromGateway(), changeOperation.getExpirationTime());
    }

    private static void validateNonCascadingConversion(IReplicationPacketEntryData entryData, AbstractReplicationPacketSingleEntryData result) throws ReplicationPacketEntryDataConversionException {
        if (result != null) {
            throw new ReplicationPacketEntryDataConversionException("Packet data [" + entryData + "] was already converted to [" + result + "]");
        }
    }

    private static AbstractReplicationPacketSingleEntryData convertFromRemoveToRemoveBackwardCompatible(IReplicationPacketEntryData entryData) {
        if (entryData.containsFullEntryData()) {
            RemoveReplicationPacketData removePacket = (RemoveReplicationPacketData)entryData;
            ITemplatePacket entryPacket = TemplatePacketFactory.createFullPacket(removePacket.getEntryPacket());
            return new RemoveReplicationPacketData(entryPacket, entryData.isFromGateway(), removePacket.getMainEntryData(), true);
        }
        return (AbstractReplicationPacketSingleEntryData)entryData;
    }

    private static RemoveByUIDReplicationPacketData convertFromUpdateToRemoveNoFullContentRequiredNoEntryData(UpdateReplicationPacketData updateOperation) {
        IEntryPacket entryPacket = updateOperation.getEntryPacket();
        return new RemoveByUIDReplicationPacketData(entryPacket.getTypeName(), entryPacket.getUID(), entryPacket.isTransient(), updateOperation.getMainEntryData(), updateOperation.getEntryPacket().getOperationID(), updateOperation.isFromGateway());
    }

    private static WriteReplicationPacketData convertFromUpdateToWriteNoEntryData(UpdateReplicationPacketData updateOperation) {
        IEntryPacket fullEntryPacket = ReplicationPacketDataConverter.getFullEntryPacketFromUpdateOperation(updateOperation, QueryResultTypeInternal.NOT_SET);
        return new WriteReplicationPacketData(fullEntryPacket, updateOperation.isFromGateway(), updateOperation.getExpirationTime());
    }

    private static IEntryPacket getFullEntryPacketFromUpdateOperation(UpdateReplicationPacketData updateOperation, QueryResultTypeInternal queryResultTypeInternal) {
        IEntryPacket fullEntryPacket = updateOperation.getEntryPacket();
        if (updateOperation instanceof PartialUpdateReplicationPacketData) {
            fullEntryPacket = queryResultTypeInternal != QueryResultTypeInternal.NOT_SET ? EntryPacketFactory.createFullPacket(updateOperation.getMainEntryData(), updateOperation.getOperationId(), updateOperation.getUid(), updateOperation.isTransient(), queryResultTypeInternal) : updateOperation.getEntryPacket().clone();
            IEntryData secondaryEntryDAta = updateOperation.getSecondaryEntryData();
            for (int i = 0; i < fullEntryPacket.getFieldValues().length; ++i) {
                if (fullEntryPacket.getFieldValue(i) != null) continue;
                fullEntryPacket.setFieldValue(i, secondaryEntryDAta.getFixedPropertyValue(i));
            }
        }
        return fullEntryPacket;
    }

    private static UpdateReplicationPacketData convertFromUpdateToUpdateFullContentRequiredNoEntryData(UpdateReplicationPacketData updateOperation, ReplicationEntryDataConversionMetadata metadata) {
        IEntryPacket fullEntryPacket = ReplicationPacketDataConverter.getFullEntryPacketFromUpdateOperation(updateOperation, metadata.getRequiredQueryResultType());
        UpdateReplicationPacketData updateReplicationPacketData = new UpdateReplicationPacketData(fullEntryPacket, updateOperation.isFromGateway(), updateOperation.isOverrideVersion(), updateOperation.getSecondaryEntryData(), metadata.getFlags(), updateOperation.getExpirationTime(), updateOperation.getMainEntryData());
        if (updateOperation.isSerializeFullContent()) {
            updateReplicationPacketData.serializeFullContent();
        }
        return updateReplicationPacketData;
    }

    private static UpdateReplicationPacketData convertFromUpdateToUpdateReliableAsyncContentRequired(UpdateReplicationPacketData entryData) {
        UpdateReplicationPacketData result = entryData.clone();
        result.serializeFullContent();
        return result;
    }

    private static AbstractReplicationPacketSingleEntryData convertFromUpdateToUpdateWithEntryData(UpdateReplicationPacketData entryData, ReplicationEntryDataConversionMetadata metadata) {
        boolean isUnmatched = NotificationReplicationChannelDataFilter.DurableNotificationConversionFlags.isUpdateToUnmatched(metadata.getFlags());
        IEntryData sourceEntryData = metadata.isModifiedByFilter() ? metadata.getEntryData() : (isUnmatched ? metadata.getEntryData() : entryData.getMainEntryData());
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacket(sourceEntryData, entryData.getOperationId(), entryData.getUid(), entryData.isTransient(), metadata.getRequiredQueryResultType());
        UpdateReplicationPacketData updateReplicationPacketData = new UpdateReplicationPacketData(entryPacket, entryData.isFromGateway(), entryData.isOverrideVersion(), isUnmatched ? entryData.getMainEntryData() : entryData.getSecondaryEntryData(), metadata.getFlags(), entryData.getExpirationTime(), sourceEntryData);
        if (entryData.isSerializeFullContent()) {
            updateReplicationPacketData.serializeFullContent();
        }
        return updateReplicationPacketData;
    }

    private static AbstractReplicationPacketSingleEntryData convertFromWriteToWriteNoFullContentRequiredWithEntryData(WriteReplicationPacketData writeOperation, ReplicationEntryDataConversionMetadata metadata) {
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacket(metadata.getEntryData(), writeOperation.getOperationId(), writeOperation.getUid(), writeOperation.isTransient(), metadata.getRequiredQueryResultType());
        return new WriteReplicationPacketData(entryPacket, writeOperation.isFromGateway(), writeOperation.getExpirationTime());
    }

    private static AbstractReplicationPacketSingleEntryData convertFromRemoveToRemoveFullContentRequired(IReplicationPacketEntryData entryData, ReplicationEntryDataConversionMetadata metadata) {
        AbstractReplicationPacketSingleEntryData entry = (AbstractReplicationPacketSingleEntryData)entryData;
        if (entry.containsFullEntryData() && metadata.getEntryData() == null) {
            return entry;
        }
        IEntryData iEntryData = metadata.getEntryData();
        if (iEntryData == null) {
            iEntryData = entry.getMainEntryData();
        }
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacket(iEntryData, entryData.getOperationId(), entryData.getUid(), entryData.isTransient(), metadata.getRequiredQueryResultType());
        return new RemoveReplicationPacketData(entryPacket, entry.isFromGateway(), iEntryData, true);
    }

    private static AbstractReplicationPacketSingleEntryData convertFromLeaseOperationToLeaseExpiredFullContentRequired(IReplicationPacketEntryData entryData, ReplicationEntryDataConversionMetadata metadata) {
        if (entryData instanceof EntryLeaseExpiredFullReplicationPacketData && metadata.getEntryData() == null && metadata.getRequiredQueryResultType() == null) {
            return (EntryLeaseExpiredFullReplicationPacketData)entryData;
        }
        AbstractReplicationPacketSingleEntryData entry = (AbstractReplicationPacketSingleEntryData)entryData;
        IEntryData iEntryData = metadata.getEntryData();
        if (iEntryData == null) {
            iEntryData = entry.getMainEntryData();
        }
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacket(iEntryData, entryData.getOperationId(), entryData.getUid(), entryData.isTransient(), metadata.getRequiredQueryResultType());
        return new EntryLeaseExpiredFullReplicationPacketData(entryPacket, entry.isFromGateway());
    }

    private static AbstractReplicationPacketSingleEntryData convertFromLeaseCancelledToLeaseCancelledFullContentRequired(IReplicationPacketEntryData entryData) {
        if (entryData instanceof CancelLeaseFullReplicationPacketData) {
            return (CancelLeaseFullReplicationPacketData)entryData;
        }
        AbstractReplicationPacketSingleEntryData entry = (AbstractReplicationPacketSingleEntryData)entryData;
        IEntryPacket templatePacket = EntryPacketFactory.createFullPacket(entry.getMainEntryData(), entryData.getOperationId(), entryData.getUid(), entryData.isTransient(), QueryResultTypeInternal.NOT_SET);
        return new CancelLeaseFullReplicationPacketData(templatePacket, entry.isFromGateway());
    }
}

