/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.cluster.node.impl.DataTypeAddIndexPacketData;
import com.gigaspaces.internal.cluster.node.impl.DataTypeIntroducePacketData;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationEntryDataConversionMetadata;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConverter;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketEntryDataConversionException;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnhandledErrorFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.CancelLeaseReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.ChangeReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.EntryLeaseExpiredReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.EvictReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.ExtendEntryLeaseReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.ExtendNotifyTemplateLeaseReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.InsertNotifyTemplateReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.NotifyTemplateLeaseExpiredReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.PartialUpdateReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.RemoveByUIDReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.RemoveNotifyTemplateReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.RemoveReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionAbortReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionCommitReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionOnePhaseReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionPrepareReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.UpdateReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.WriteReplicationPacketData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.ICustomTypeDescLoader;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class ReplicationPacketDataProducer
implements IReplicationPacketDataProducer<IExecutableReplicationPacketData<?>> {
    private final boolean _replicateToTargetWithExternalDatasource;
    private final boolean _replicateFullTake;
    private final SpaceEngine _spaceEngine;
    private final ReplicationPacketDataMediator _packetDataMediator;

    public ReplicationPacketDataProducer(SpaceEngine spaceEngine, boolean replicateToTargetWithExternalDatasource, boolean replicateFullTake, ReplicationPacketDataMediator packetDataMediator) {
        this._spaceEngine = spaceEngine;
        this._replicateToTargetWithExternalDatasource = replicateToTargetWithExternalDatasource;
        this._replicateFullTake = replicateFullTake;
        this._packetDataMediator = packetDataMediator;
    }

    @Override
    public IExecutableReplicationPacketData<?> createSingleOperationData(IEntryHolder entryHolder, ReplicationSingleOperationType operationType, ReplicationOutContext replicationOutContext) {
        switch (operationType) {
            case WRITE: {
                return this.createWriteReplicationPacket(entryHolder, replicationOutContext.getOperationID(), replicationOutContext.isFromGateway());
            }
            case UPDATE: {
                return this.createUpdateReplicationPacket(entryHolder, replicationOutContext.getOperationID(), replicationOutContext.getPartialUpdatedValuesIndicators(), replicationOutContext.isFromGateway(), replicationOutContext.isOverrideVersion(entryHolder.getUID()), replicationOutContext.getPreviousUpdatedEntryData());
            }
            case CHANGE: {
                return this.createChangeReplicationPacket(entryHolder, replicationOutContext.getOperationID(), replicationOutContext.getSpaceEntryMutators(), replicationOutContext.getPreviousUpdatedEntryData(), replicationOutContext.isFromGateway());
            }
            case REMOVE_ENTRY: {
                return (IExecutableReplicationPacketData)((Object)this.createRemoveReplicationPacket(entryHolder, replicationOutContext.getOperationID(), replicationOutContext.isFromGateway()));
            }
            case INSERT_NOTIFY_TEMPLATE: {
                return this.createInsertNotifyReplicationPacket((NotifyTemplateHolder)entryHolder, replicationOutContext.getOperationID());
            }
            case REMOVE_NOTIFY_TEMPLATE: {
                return this.createRemoveNotifyReplicationPacket((NotifyTemplateHolder)entryHolder, replicationOutContext.getOperationID());
            }
            case CANCEL_LEASE: {
                return this.createCancelLeaseReplicationPacket(entryHolder, replicationOutContext.getOperationID(), replicationOutContext.isFromGateway());
            }
            case EVICT: {
                return this.createEvictReplicationPacket(entryHolder, replicationOutContext.getOperationID());
            }
            case EXTEND_ENTRY_LEASE: {
                return this.createExtendEntryLeaseReplicationPacket(entryHolder, replicationOutContext.getOperationID(), replicationOutContext.isFromGateway());
            }
            case EXTEND_NOTIFY_TEMPLATE_LEASE: {
                return this.createExtendNotifyTemplateLeaseReplicationPacket((NotifyTemplateHolder)entryHolder, replicationOutContext.getOperationID());
            }
            case ENTRY_LEASE_EXPIRED: {
                return this.createEntryLeaseExpiredReplicationPacket(entryHolder, replicationOutContext.getOperationID());
            }
            case NOTIFY_TEMPLATE_LEASE_EXPIRED: {
                return this.createNotifyTemplateLeaseExpiredReplicationPacket((NotifyTemplateHolder)entryHolder, replicationOutContext.getOperationID());
            }
        }
        throw new UnsupportedOperationException("Unknown replication operation type " + (Object)((Object)operationType));
    }

    @Override
    public IExecutableReplicationPacketData<?> createGenericOperationData(Object operationData, ReplicationSingleOperationType operationType, ReplicationOutContext entireContext) {
        switch (operationType) {
            case DATA_TYPE_INTRODUCE: {
                return new DataTypeIntroducePacketData((ITypeDesc)operationData, entireContext.isFromGateway());
            }
            case DATA_TYPE_ADD_INDEX: {
                return new DataTypeAddIndexPacketData((AddTypeIndexesRequestInfo)operationData, entireContext.isFromGateway());
            }
        }
        throw new UnsupportedOperationException("Unknown replication operation type " + (Object)((Object)operationType));
    }

    @Override
    public IExecutableReplicationPacketData<IReplicationTransactionalPacketEntryData> createTransactionOperationData(ServerTransaction transaction, ArrayList<IEntryHolder> entries, ReplicationOutContext replicationOutContext, ReplicationMultipleOperationType operationType) {
        AbstractTransactionReplicationPacketData transactionPacket = this.createTransactionPacket(operationType, transaction, replicationOutContext.getOperationID(), replicationOutContext.isFromGateway());
        if (operationType == ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_COMMIT || operationType == ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_ABORT) {
            List<IReplicationTransactionalPacketEntryData> pendingTransactionData = this._packetDataMediator.removePendingTransactionData(transaction);
            if (pendingTransactionData == null) {
                throw new ReplicationInternalSpaceException("Attempt to create " + (Object)((Object)operationType) + " packet while there is no pending transaction content");
            }
            for (IReplicationTransactionalPacketEntryData entryData : pendingTransactionData) {
                transactionPacket.add(entryData);
            }
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                IReplicationTransactionalPacketEntryData singlePacket;
                IEntryHolder entryHolder = entries.get(i);
                if (entryHolder == null || !replicationOutContext.getShouldReplicate()[i] || entryHolder.isDeleted() || entryHolder.getWriteLockTransaction() == null || !entryHolder.getWriteLockTransaction().equals((Object)transaction)) continue;
                switch (entryHolder.getWriteLockOperation()) {
                    case 1: {
                        singlePacket = this.createWriteReplicationPacket(entryHolder, replicationOutContext.getOperationIDs()[i], replicationOutContext.isFromGateway());
                        break;
                    }
                    case 7: {
                        Object updateInfo = replicationOutContext.getPartialUpdatesAndInPlaceUpdatesInfo().get(entryHolder.getUID());
                        if (updateInfo instanceof Collection) {
                            singlePacket = this.createChangeReplicationPacket(entryHolder, replicationOutContext.getOperationIDs()[i], (Collection)updateInfo, entryHolder.getShadow().getEntryData(), replicationOutContext.isFromGateway());
                            break;
                        }
                        boolean[] partialUpdateIndicators = (boolean[])updateInfo;
                        if (partialUpdateIndicators != null && partialUpdateIndicators.length == 0) {
                            partialUpdateIndicators = null;
                        }
                        singlePacket = this.createUpdateReplicationPacket(entryHolder, replicationOutContext.getOperationIDs()[i], partialUpdateIndicators, replicationOutContext.isFromGateway(), replicationOutContext.isOverrideVersion(entryHolder.getUID()), entryHolder.getShadow().getEntryData());
                        break;
                    }
                    case 4: 
                    case 5: {
                        singlePacket = (IReplicationTransactionalPacketEntryData)this.createRemoveReplicationPacket(entryHolder, replicationOutContext.getOperationIDs()[i], replicationOutContext.isFromGateway());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported transactional operation - " + entryHolder.getWriteLockOperation());
                    }
                }
                if (singlePacket.isTransient()) {
                    transactionPacket.setHasTransientMembersFlag();
                } else {
                    transactionPacket.setHasPersistentMembersFlag();
                }
                transactionPacket.add(singlePacket);
            }
            if (operationType == ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_PREPARE) {
                this._packetDataMediator.setPendingTransactionData(transaction, transactionPacket);
            }
        }
        return transactionPacket;
    }

    private AbstractTransactionReplicationPacketData createTransactionPacket(ReplicationMultipleOperationType operationType, ServerTransaction transaction, OperationID operationID, boolean fromGateway) {
        switch (operationType) {
            case TRANSACTION_ONE_PHASE: {
                TransactionOnePhaseReplicationPacketData data = new TransactionOnePhaseReplicationPacketData(operationID, fromGateway);
                data.setMetaData(transaction.getMetaData());
                return data;
            }
            case TRANSACTION_TWO_PHASE_PREPARE: {
                return new TransactionPrepareReplicationPacketData(transaction, fromGateway);
            }
            case TRANSACTION_TWO_PHASE_COMMIT: {
                return new TransactionCommitReplicationPacketData(transaction, operationID, fromGateway);
            }
            case TRANSACTION_TWO_PHASE_ABORT: {
                return new TransactionAbortReplicationPacketData(transaction, operationID, fromGateway);
            }
        }
        throw new IllegalArgumentException("unknown operation type for transaction packet generation [" + (Object)((Object)operationType) + "]");
    }

    private CancelLeaseReplicationPacketData createCancelLeaseReplicationPacket(IEntryHolder entryHolder, OperationID operationID, boolean isFromGateway) {
        return new CancelLeaseReplicationPacketData(entryHolder.getClassName(), entryHolder.getUID(), entryHolder.isTransient(), entryHolder.getEntryData(), operationID, entryHolder.getRoutingValue() != null ? entryHolder.getRoutingValue().hashCode() : -1, isFromGateway);
    }

    private EntryLeaseExpiredReplicationPacketData createEntryLeaseExpiredReplicationPacket(IEntryHolder entryHolder, OperationID operationID) {
        return new EntryLeaseExpiredReplicationPacketData(entryHolder.getClassName(), entryHolder.getUID(), entryHolder.isTransient(), entryHolder.getEntryData(), operationID);
    }

    private NotifyTemplateLeaseExpiredReplicationPacketData createNotifyTemplateLeaseExpiredReplicationPacket(NotifyTemplateHolder templateHolder, OperationID operationID) {
        return new NotifyTemplateLeaseExpiredReplicationPacketData(templateHolder.getClassName(), templateHolder.getUID(), templateHolder.getEntryData(), operationID);
    }

    private EvictReplicationPacketData createEvictReplicationPacket(IEntryHolder entryHolder, OperationID operationID) {
        return new EvictReplicationPacketData(entryHolder.getClassName(), entryHolder.getUID(), entryHolder.isTransient(), entryHolder.getEntryData(), operationID);
    }

    private WriteReplicationPacketData createWriteReplicationPacket(IEntryHolder entryHolder, OperationID operationID, boolean fromGateway) {
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacketForReplication(entryHolder, operationID);
        return new WriteReplicationPacketData(entryPacket, fromGateway, entryHolder.getEntryData().getExpirationTime());
    }

    private UpdateReplicationPacketData createUpdateReplicationPacket(IEntryHolder entryHolder, OperationID operationID, boolean[] partialUpdatedValuesIndicators, boolean fromGateway, boolean overrideVersion, IEntryData previousEntryData) {
        if (this.isPartialUpdate(entryHolder, partialUpdatedValuesIndicators)) {
            IEntryPacket entryPacket = EntryPacketFactory.createPartialUpdatePacketForReplication(entryHolder, operationID, partialUpdatedValuesIndicators);
            if (entryHolder.hasShadow()) {
                entryPacket.setPreviousVersion(entryHolder.getShadow().getVersionID());
            }
            return new PartialUpdateReplicationPacketData(entryPacket, fromGateway, overrideVersion, previousEntryData, entryHolder.getEntryData().getExpirationTime(), entryHolder.getEntryData());
        }
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacketForReplication(entryHolder, operationID);
        if (entryHolder.hasShadow()) {
            entryPacket.setPreviousVersion(entryHolder.getShadow().getVersionID());
        }
        return new UpdateReplicationPacketData(entryPacket, fromGateway, overrideVersion, previousEntryData, 0, entryHolder.getEntryData().getExpirationTime(), entryHolder.getEntryData());
    }

    private boolean isPartialUpdate(IEntryHolder entryHolder, boolean[] partialUpdatedValuesIndicators) {
        if (partialUpdatedValuesIndicators == null || partialUpdatedValuesIndicators.length == 0) {
            return false;
        }
        if (entryHolder.isTransient()) {
            return true;
        }
        if (this._spaceEngine.getClusterPolicy().getReplicationPolicy().isMirrorServiceEnabled()) {
            return this._spaceEngine.getClusterPolicy().getReplicationPolicy().getMirrorServiceConfig().supportsPartialUpdate;
        }
        return true;
    }

    private ChangeReplicationPacketData createChangeReplicationPacket(IEntryHolder entryHolder, OperationID operationID, Collection<SpaceEntryMutator> spaceEntryMutators, IEntryData previousUpdatedEntryData, boolean isFromGateway) {
        int previousVersion = entryHolder.hasShadow() ? entryHolder.getShadow().getVersionID() : 0;
        int currentVersion = entryHolder.getEntryData().getVersion();
        return new ChangeReplicationPacketData(entryHolder.getClassName(), entryHolder.getUID(), entryHolder.getEntryId(), currentVersion, previousVersion, entryHolder.isTransient(), entryHolder.getEntryData(), operationID, entryHolder.getRoutingValue() != null ? entryHolder.getRoutingValue().hashCode() : -1, spaceEntryMutators, previousUpdatedEntryData, entryHolder.getEntryData().getTimeToLive(false), entryHolder.getEntryData().getExpirationTime(), isFromGateway);
    }

    private IReplicationPacketEntryData createRemoveReplicationPacket(IEntryHolder entryHolder, OperationID operationID, boolean fromGateway) {
        if (this._replicateFullTake) {
            return this.createFullRemoveReplicationPacket(entryHolder, operationID, fromGateway);
        }
        if (this._replicateToTargetWithExternalDatasource && !entryHolder.isTransient()) {
            return this.createRemoveReplicationPacketForPersistency(entryHolder, operationID, fromGateway);
        }
        return this.createRemoveByUIDReplicationPacket(entryHolder, operationID, fromGateway);
    }

    private RemoveByUIDReplicationPacketData createRemoveByUIDReplicationPacket(IEntryHolder entryHolder, OperationID operationID, boolean fromGateway) {
        return new RemoveByUIDReplicationPacketData(entryHolder.getClassName(), entryHolder.getUID(), entryHolder.isTransient(), entryHolder.getEntryData(), operationID, fromGateway);
    }

    private RemoveReplicationPacketData createFullRemoveReplicationPacket(IEntryHolder entryHolder, OperationID operationID, boolean fromGateway) {
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacketForReplication(entryHolder, operationID);
        return new RemoveReplicationPacketData(entryPacket, fromGateway, entryHolder.getEntryData(), true);
    }

    private RemoveReplicationPacketData createRemoveReplicationPacketForPersistency(IEntryHolder entryHolder, OperationID operationID, boolean originGateway) {
        IEntryPacket template = EntryPacketFactory.createRemovePacketForPersistency(entryHolder, operationID);
        return new RemoveReplicationPacketData(template, originGateway, entryHolder.getEntryData(), false);
    }

    private SingleReplicationPacketData createInsertNotifyReplicationPacket(NotifyTemplateHolder templateHolder, OperationID operationID) {
        ITemplatePacket templatePacket = TemplatePacketFactory.createFullPacketForReplication(templateHolder, operationID);
        long expirationTime = templateHolder.getEntryData().getExpirationTime();
        return new InsertNotifyTemplateReplicationPacketData(templatePacket, templateHolder.getUID(), templateHolder.getNotifyInfo(), expirationTime);
    }

    private RemoveNotifyTemplateReplicationPacketData createRemoveNotifyReplicationPacket(NotifyTemplateHolder templateHolder, OperationID operationID) {
        return new RemoveNotifyTemplateReplicationPacketData(templateHolder.getClassName(), templateHolder.getNotifyInfo(), templateHolder.getSpaceItemType(), templateHolder.getUID(), templateHolder.isTransient(), templateHolder.getEntryData(), operationID);
    }

    private ExtendEntryLeaseReplicationPacketData createExtendEntryLeaseReplicationPacket(IEntryHolder entryHolder, OperationID operationID, boolean isFromGateway) {
        long expirationTime = entryHolder.getEntryData().getExpirationTime();
        long timeToLive = expirationTime - SystemTime.timeMillis();
        return new ExtendEntryLeaseReplicationPacketData(entryHolder.getClassName(), entryHolder.getUID(), entryHolder.isTransient(), entryHolder.getEntryData(), expirationTime, timeToLive, operationID, entryHolder.getRoutingValue() != null ? entryHolder.getRoutingValue().hashCode() : -1, isFromGateway);
    }

    private ExtendNotifyTemplateLeaseReplicationPacketData createExtendNotifyTemplateLeaseReplicationPacket(NotifyTemplateHolder entryHolder, OperationID operationID) {
        long expirationTime = entryHolder.getEntryData().getExpirationTime();
        long timeToLive = expirationTime - SystemTime.timeMillis();
        return new ExtendNotifyTemplateLeaseReplicationPacketData(entryHolder.getClassName(), entryHolder.getUID(), entryHolder.isTransient(), entryHolder.getEntryData(), expirationTime, timeToLive, entryHolder.getSpaceItemType(), entryHolder.getNotifyInfo(), operationID);
    }

    public AbstractDataConsumeFix createFix(IDataConsumeResult errorResult, IExecutableReplicationPacketData<?> errorData) {
        AbstractDataConsumeErrorResult typedErrorResult = (AbstractDataConsumeErrorResult)errorResult;
        return typedErrorResult.createFix(this._spaceEngine, this, errorData);
    }

    public AbstractDataConsumeFix createFixForUnknownError(Throwable error) {
        return new UnhandledErrorFix(error);
    }

    @Override
    public Iterable<IReplicationFilterEntry> toFilterEntries(IExecutableReplicationPacketData<?> data) {
        return data.toFilterEntries(this._spaceEngine.getTypeManager());
    }

    @Override
    public IEntryData getMainEntryData(IReplicationPacketEntryData data) {
        IEntryData mainEntryData = ((AbstractReplicationPacketSingleEntryData)data).getMainEntryData();
        return this.loadTypeDescIntoEntryIfNeeded(mainEntryData);
    }

    @Override
    public IEntryData getSecondaryEntryData(IReplicationPacketEntryData data) {
        IEntryData secondaryEntryData = ((AbstractReplicationPacketSingleEntryData)data).getSecondaryEntryData();
        return this.loadTypeDescIntoEntryIfNeeded(secondaryEntryData);
    }

    private IEntryData loadTypeDescIntoEntryIfNeeded(IEntryData entryData) {
        if (entryData == null) {
            return null;
        }
        if (entryData.getSpaceTypeDescriptor() == null) {
            if (entryData instanceof ICustomTypeDescLoader) {
                ((ICustomTypeDescLoader)((Object)entryData)).loadTypeDescriptor(this._spaceEngine.getTypeManager());
            } else {
                throw new IllegalStateException("Received server entry is not of type " + ICustomTypeDescLoader.class + ", it is of type " + entryData.getClass());
            }
        }
        return entryData;
    }

    @Override
    public String getMainTypeName(IReplicationPacketEntryData data) {
        IEntryData mainServerEntry = this.getMainEntryData(data);
        if (mainServerEntry != null) {
            return mainServerEntry.getSpaceTypeDescriptor().getTypeName();
        }
        return ((AbstractReplicationPacketSingleEntryData)data).getMainTypeName();
    }

    @Override
    public <T> T getCustomContent(IReplicationPacketEntryData data) {
        return (T)((AbstractReplicationPacketSingleEntryData)data).getCustomContent();
    }

    @Override
    public AbstractReplicationPacketSingleEntryData convertEntryData(IReplicationPacketEntryData entryData, ReplicationEntryDataConversionMetadata metadata, PlatformLogicalVersion targetMemberVersion) throws ReplicationPacketEntryDataConversionException {
        return ReplicationPacketDataConverter.convert(entryData, metadata, targetMemberVersion);
    }

    @Override
    public IExecutableReplicationPacketData<?> convertSingleEntryData(IExecutableReplicationPacketData<?> singleEntryData, ReplicationEntryDataConversionMetadata metadata, PlatformLogicalVersion targetMemberVersion) throws ReplicationPacketEntryDataConversionException {
        IReplicationPacketEntryData entryData = singleEntryData.getSingleEntryData();
        return this.convertEntryData(entryData, metadata, targetMemberVersion);
    }

    @Override
    public IExecutableReplicationPacketData<?> convertData(IExecutableReplicationPacketData<?> data, ReplicationMultipleOperationType convertToOperation, PlatformLogicalVersion targetMemberVersion) throws ReplicationPacketEntryDataConversionException {
        switch (data.getMultipleOperationType()) {
            case TRANSACTION_ONE_PHASE: {
                break;
            }
            case TRANSACTION_TWO_PHASE_COMMIT: {
                if (convertToOperation != ReplicationMultipleOperationType.TRANSACTION_ONE_PHASE) break;
                TransactionCommitReplicationPacketData typedData = (TransactionCommitReplicationPacketData)data;
                TransactionOnePhaseReplicationPacketData convertedData = new TransactionOnePhaseReplicationPacketData(typedData.getOperationID(), data.isFromGateway());
                convertedData.setMetaData(typedData.getMetaData());
                this.copyTransactionData(convertedData, typedData);
                return convertedData;
            }
        }
        throw new ReplicationPacketEntryDataConversionException("Cannot convert [" + (Object)((Object)data.getMultipleOperationType()) + "] to [" + (Object)((Object)convertToOperation) + "]");
    }

    private IExecutableReplicationPacketData<?> createOldOnePhaseTransactionPacket(AbstractTransactionReplicationPacketData data) {
        TransactionReplicationPacketData convertedData = new TransactionReplicationPacketData();
        convertedData.setMetaData(data.getMetaData());
        this.copyTransactionData(convertedData, data);
        return convertedData;
    }

    private void copyTransactionData(List<IReplicationTransactionalPacketEntryData> convertedData, List<IReplicationTransactionalPacketEntryData> typedData) {
        for (IReplicationTransactionalPacketEntryData entryData : typedData) {
            convertedData.add(entryData);
        }
    }

    @Override
    public IExecutableReplicationPacketData<?> createEmptyMultipleEntryData(IExecutableReplicationPacketData<?> data) {
        return data.createEmptyMultipleEntryData();
    }

    @Override
    public void setSerializeWithFullContent(IReplicationPacketEntryData entryData) {
        if (entryData instanceof UpdateReplicationPacketData) {
            UpdateReplicationPacketData updateData = (UpdateReplicationPacketData)entryData;
            updateData.serializeFullContent();
        }
    }

    @Override
    public boolean requiresConversion(IReplicationPacketEntryData entryData, QueryResultTypeInternal queryResultType) {
        if (!queryResultType.isPbs()) {
            return false;
        }
        if (!(entryData instanceof SingleReplicationPacketData)) {
            return false;
        }
        return ((SingleReplicationPacketData)entryData).getEntryPacket().getPacketType() != TransportPacketType.PBS;
    }

    @Override
    public void completePacketDataContent(IExecutableReplicationPacketData<?> data) {
        if (data.isSingleEntryData()) {
            this.getMainEntryData(data.getSingleEntryData());
            this.getSecondaryEntryData(data.getSingleEntryData());
        } else {
            for (IReplicationPacketEntryData entryData : data) {
                this.getMainEntryData(entryData);
                this.getSecondaryEntryData(entryData);
            }
        }
    }

    @Override
    public boolean isPrimary() {
        return this._spaceEngine.getSpaceImpl().isPrimary();
    }
}

