/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.DiscardReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFixFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;

@InternalApi
public class ResurrectEntryFix
extends AbstractDataConsumeFix {
    private static final long serialVersionUID = 1L;
    private IEntryPacket _entryPacket;

    public ResurrectEntryFix() {
    }

    public ResurrectEntryFix(IEntryPacket entryPacket) {
        this._entryPacket = entryPacket;
    }

    @Override
    public IExecutableReplicationPacketData<?> fix(IReplicationInContext context, IDataConsumeFixFacade fixFacade, ReplicationPacketDataConsumer consumer, IExecutableReplicationPacketData<?> data) throws Exception {
        try {
            fixFacade.write(this._entryPacket);
            return DiscardReplicationPacketData.instance();
        }
        catch (EntryAlreadyInSpaceException e) {
            if (context.getContextLogger().isLoggable(Level.SEVERE)) {
                context.getContextLogger().severe("Detected conflicting WRITE operation on entry - <" + this._entryPacket.getTypeName() + "> uid=<" + this._entryPacket.getUID() + ">\n  Ignoring the conflicting operation since it has already been applied to space.\n  Please make sure that the entry was not simultaneously changed in two different space instances.");
            }
            return DiscardReplicationPacketData.instance();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._entryPacket = (IEntryPacket)IOUtils.readObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._entryPacket);
    }

    public String toString() {
        return "ResurrectEntryFix - " + this._entryPacket;
    }
}

