/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataProducer;
import com.gigaspaces.internal.server.space.SpaceEngine;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class UnknownConsumeErrorResult
extends AbstractDataConsumeErrorResult {
    private static final long serialVersionUID = 1L;
    private Throwable _error;

    public UnknownConsumeErrorResult() {
    }

    public UnknownConsumeErrorResult(Throwable error) {
        this._error = error;
    }

    @Override
    public AbstractDataConsumeFix createFix(SpaceEngine spaceEngine, ReplicationPacketDataProducer producer, IExecutableReplicationPacketData errorData) {
        return producer.createFixForUnknownError(this._error);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._error = (Throwable)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._error);
    }

    @Override
    public Exception toException() {
        if (this._error instanceof Exception) {
            return (Exception)this._error;
        }
        return new Exception(this._error.getMessage(), this._error);
    }

    @Override
    public boolean sameFailure(IDataConsumeResult otherResult) {
        if (!(otherResult instanceof UnknownConsumeErrorResult)) {
            return false;
        }
        Throwable otherError = ((UnknownConsumeErrorResult)otherResult)._error;
        if (otherError == this._error) {
            return true;
        }
        if (this._error == null || otherError == null) {
            return false;
        }
        if (!otherError.getClass().equals(this._error.getClass())) {
            return false;
        }
        if (!otherError.getMessage().equals(this._error.getMessage())) {
            return false;
        }
        return otherError.toString().equals(this._error.toString());
    }
}

