/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.handlers.UnknownEntryLeaseException;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.ResurrectEntryFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnknownLeaseErrorUnfixed;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.SAException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class UnknownEntryLeaseConsumeResult
extends AbstractDataConsumeErrorResult {
    private static final long serialVersionUID = 1L;
    private String _className;
    private String _uid;
    private OperationID _operationID;
    private transient UnknownEntryLeaseException _error;

    public UnknownEntryLeaseConsumeResult() {
    }

    public UnknownEntryLeaseConsumeResult(String className, String uid, OperationID operationId, UnknownEntryLeaseException error) {
        this._className = className;
        this._uid = uid;
        this._operationID = operationId;
        this._error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractDataConsumeFix createFix(SpaceEngine spaceEngine, ReplicationPacketDataProducer producer, IExecutableReplicationPacketData errorData) {
        Context context = spaceEngine.getCacheManager().getCacheContext();
        try {
            IEntryHolder entryHolder = spaceEngine.getCacheManager().getEntry(context, this._uid, this._className, null, false, false, false);
            if (entryHolder == null || entryHolder.isDeleted() || entryHolder.isExpired()) {
                UnknownLeaseErrorUnfixed unknownLeaseErrorUnfixed = new UnknownLeaseErrorUnfixed(this._className, this._uid);
                return unknownLeaseErrorUnfixed;
            }
            IEntryPacket entryPacket = EntryPacketFactory.createFullPacketForReplication(entryHolder, this._operationID);
            entryPacket.setSerializeTypeDesc(true);
            long expirationTime = entryHolder.getEntryData().getExpirationTime();
            if (expirationTime != Long.MAX_VALUE) {
                long ttl = expirationTime - SystemTime.timeMillis();
                if (ttl <= 0L) {
                    UnknownLeaseErrorUnfixed unknownLeaseErrorUnfixed = new UnknownLeaseErrorUnfixed(this._className, this._uid);
                    return unknownLeaseErrorUnfixed;
                }
                entryPacket.setTTL(ttl);
            }
            entryPacket.setVersion(0);
            ResurrectEntryFix resurrectEntryFix = new ResurrectEntryFix(entryPacket);
            return resurrectEntryFix;
        }
        catch (SAException e) {
            UnknownLeaseErrorUnfixed unknownLeaseErrorUnfixed = new UnknownLeaseErrorUnfixed(this._className, this._uid);
            return unknownLeaseErrorUnfixed;
        }
        finally {
            spaceEngine.getCacheManager().freeCacheContext(context);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._className = IOUtils.readString(in);
        this._uid = IOUtils.readString(in);
        this._operationID = (OperationID)IOUtils.readObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._className);
        IOUtils.writeString(out, this._uid);
        IOUtils.writeObject(out, this._operationID);
    }

    @Override
    public Exception toException() {
        return this._error;
    }

    @Override
    public boolean sameFailure(IDataConsumeResult otherResult) {
        return false;
    }
}

