/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.DiscardReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFixFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;

@InternalApi
public class UnknownLeaseErrorUnfixed
extends AbstractDataConsumeFix {
    private static final long serialVersionUID = 1L;
    private String _className;
    private String _uid;

    public UnknownLeaseErrorUnfixed() {
    }

    public UnknownLeaseErrorUnfixed(String className, String uid) {
        this._className = className;
        this._uid = uid;
    }

    @Override
    public IExecutableReplicationPacketData<?> fix(IReplicationInContext context, IDataConsumeFixFacade fixFacade, ReplicationPacketDataConsumer consumer, IExecutableReplicationPacketData<?> data) {
        if (context.getContextLogger().isLoggable(Level.WARNING)) {
            context.getContextLogger().log(Level.WARNING, "Failed to renew Entry lease: " + this._className + " UID: " + this._uid + ".\nThis entry might be already expired or canceled.");
        }
        return DiscardReplicationPacketData.instance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._className = IOUtils.readString(in);
        this._uid = IOUtils.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._className);
        IOUtils.writeString(out, this._uid);
    }

    public String toString() {
        return "UnknownLeaseErrorUnfixed - ClassName=" + this._className + " UID=" + this._uid;
    }
}

