/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.handlers.UnknownNotifyTemplateLeaseException;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.ResurrectNotifyTemplateFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnknownLeaseErrorUnfixed;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class UnknownNotifyTemplateLeaseConsumeResult
extends AbstractDataConsumeErrorResult {
    private static final long serialVersionUID = 1L;
    private String _className;
    private String _uid;
    private transient UnknownNotifyTemplateLeaseException _error;

    public UnknownNotifyTemplateLeaseConsumeResult() {
    }

    public UnknownNotifyTemplateLeaseConsumeResult(String className, String uid, UnknownNotifyTemplateLeaseException error) {
        this._className = className;
        this._uid = uid;
        this._error = error;
    }

    @Override
    public AbstractDataConsumeFix createFix(SpaceEngine spaceEngine, ReplicationPacketDataProducer producer, IExecutableReplicationPacketData errorData) {
        NotifyTemplateHolder templateHolder = (NotifyTemplateHolder)spaceEngine.getCacheManager().getTemplate(this._uid);
        if (templateHolder == null || templateHolder.isDeleted() || templateHolder.isExpired()) {
            return new UnknownLeaseErrorUnfixed(this._className, this._uid);
        }
        ITemplatePacket templatePacket = TemplatePacketFactory.createFullPacketForReplication(templateHolder, templateHolder.getOperationID());
        templatePacket.setSerializeTypeDesc(true);
        long expirationTime = templateHolder.getEntryData().getExpirationTime();
        if (expirationTime != Long.MAX_VALUE) {
            long ttl = expirationTime - SystemTime.timeMillis();
            if (ttl <= 0L) {
                return new UnknownLeaseErrorUnfixed(this._className, this._uid);
            }
            templatePacket.setTTL(ttl);
        }
        return new ResurrectNotifyTemplateFix(templatePacket, this._uid, templateHolder.getNotifyInfo());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._className = IOUtils.readString(in);
        this._uid = IOUtils.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._className);
        IOUtils.writeString(out, this._uid);
    }

    @Override
    public Exception toException() {
        return this._error;
    }

    @Override
    public boolean sameFailure(IDataConsumeResult otherResult) {
        return false;
    }
}

