/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.RestoreFullTransactionFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.UnhandledErrorFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.TransactionOnePhaseReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.SpaceEngine;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.transaction.UnknownTransactionException;

@InternalApi
public class UnknownTransactionConsumeResult
extends AbstractDataConsumeErrorResult {
    private static final long serialVersionUID = 1L;
    private UnknownTransactionException _exception;

    public UnknownTransactionConsumeResult() {
    }

    public UnknownTransactionConsumeResult(UnknownTransactionException exception) {
        this._exception = exception;
    }

    @Override
    public Exception toException() {
        return this._exception;
    }

    @Override
    public boolean sameFailure(IDataConsumeResult otherResult) {
        if (!(otherResult instanceof UnknownTransactionConsumeResult)) {
            return false;
        }
        UnknownTransactionConsumeResult typedOtherResult = (UnknownTransactionConsumeResult)otherResult;
        return typedOtherResult._exception.toString().equals(this._exception.toString());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, (Object)this._exception);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._exception = (UnknownTransactionException)((Object)IOUtils.readObject(in));
    }

    @Override
    public AbstractDataConsumeFix createFix(SpaceEngine spaceEngine, ReplicationPacketDataProducer producer, IExecutableReplicationPacketData errorData) {
        if (errorData != null && errorData.getMultipleOperationType() == ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_COMMIT) {
            AbstractTransactionReplicationPacketData typedData = (AbstractTransactionReplicationPacketData)errorData;
            TransactionOnePhaseReplicationPacketData restoredTransaction = new TransactionOnePhaseReplicationPacketData(typedData.getOperationID(), typedData.isFromGateway());
            restoredTransaction.setMetaData(typedData.getMetaData());
            for (IReplicationTransactionalPacketEntryData entryData : typedData) {
                restoredTransaction.add(entryData);
            }
            return new RestoreFullTransactionFix(restoredTransaction);
        }
        return new UnhandledErrorFix(this._exception);
    }
}

