/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeErrorResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.AbstractDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.errors.TypeDescriptorConsumeFix;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.j_spaces.core.UnknownTypeException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class UnknownTypeConsumeResult
extends AbstractDataConsumeErrorResult {
    private static final long serialVersionUID = 1L;
    private String _unknownTypeClassName;
    private transient UnknownTypeException _exception;

    public UnknownTypeConsumeResult() {
    }

    public UnknownTypeConsumeResult(String unknownTypeClassName, UnknownTypeException exception) {
        this._unknownTypeClassName = unknownTypeClassName;
        this._exception = exception;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._unknownTypeClassName = IOUtils.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._unknownTypeClassName);
    }

    @Override
    public AbstractDataConsumeFix createFix(SpaceEngine spaceEngine, ReplicationPacketDataProducer producer, IExecutableReplicationPacketData errorData) {
        ITypeDesc typeDescriptor = spaceEngine.getTypeManager().getTypeDesc(this._unknownTypeClassName);
        return new TypeDescriptorConsumeFix(typeDescriptor);
    }

    @Override
    public Exception toException() {
        return this._exception;
    }

    @Override
    public boolean sameFailure(IDataConsumeResult otherResult) {
        if (!(otherResult instanceof UnknownTypeConsumeResult)) {
            return false;
        }
        return ((UnknownTypeConsumeResult)otherResult)._unknownTypeClassName.equals(this._unknownTypeClassName);
    }
}

