/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.AbstractEntryType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.rmi.MarshalledObject;
import java.util.Map;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class ReplicationFilterEntryDataWrapper
extends AbstractEntryType
implements IReplicationFilterEntry {
    private static final long serialVersionUID = 1L;
    private final AbstractReplicationPacketSingleEntryData _data;
    private final IEntryPacket _entryPacket;
    private final ReplicationOperationType _operationType;
    private final int _objectType;

    public ReplicationFilterEntryDataWrapper(AbstractReplicationPacketSingleEntryData data, IEntryPacket entryPacket, ITypeDesc typeDesc, ReplicationOperationType operationType, int objectType) {
        super(typeDesc);
        this._data = data;
        this._entryPacket = entryPacket;
        this._operationType = operationType;
        this._objectType = objectType;
    }

    @Override
    public void discard() {
        this._data.clear();
    }

    @Override
    public int getObjectType() {
        return this._objectType;
    }

    @Override
    public ReplicationOperationType getOperationType() {
        return this._operationType;
    }

    @Override
    public boolean isDiscarded() {
        return this._data.isEmpty();
    }

    @Override
    public void setFieldsValues(Object[] values) {
        this._entryPacket.setFieldsValues(values);
    }

    @Override
    public void setTimeToLive(long time) {
        this._entryPacket.setTTL(time);
    }

    @Override
    public MarshalledObject getHandback() {
        return null;
    }

    @Override
    public int getNotifyType() {
        return 0;
    }

    @Override
    public Object getObject(IJSpace space) throws UnusableEntryException {
        if (this._entryPacket == null) {
            return null;
        }
        this._entryPacket.setTypeDesc(this._typeDesc, false);
        return this._entryPacket.toObject(this._entryPacket.getEntryType());
    }

    @Override
    public Object getFieldValue(int position) throws IllegalArgumentException, IllegalStateException {
        return this._entryPacket.getFieldValue(position);
    }

    @Override
    public Object getFieldValue(String fieldName) throws IllegalArgumentException, IllegalStateException {
        return this._entryPacket.getPropertyValue(fieldName);
    }

    @Override
    public Object[] getFieldsValues() {
        return this._entryPacket.getFieldValues();
    }

    @Override
    public Map.Entry getMapEntry() {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return this._entryPacket.getTTL();
    }

    @Override
    public String getUID() {
        return this._entryPacket.getUID();
    }

    @Override
    public int getVersion() {
        return this._entryPacket.getVersion();
    }

    @Override
    public boolean isTransient() {
        return this._entryPacket.isTransient();
    }

    @Override
    public Object setFieldValue(String fieldName, Object value) throws IllegalArgumentException, IllegalStateException {
        this._entryPacket.setPropertyValue(fieldName, value);
        return this._entryPacket.getPropertyValue(fieldName);
    }

    @Override
    public Object setFieldValue(int position, Object value) throws IllegalArgumentException, IllegalStateException {
        this._entryPacket.setFieldValue(position, value);
        return this._entryPacket.getFieldValue(position);
    }

    public String toString() {
        return "ReplicationFilterEntryDataWrapper [" + this._data + "]";
    }
}

