/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ITimeToLiveUpdateCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.core.AbstractEntryType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.rmi.MarshalledObject;
import java.util.Map;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class ReplicationFilterUidDataWrapper
extends AbstractEntryType
implements IReplicationFilterEntry {
    private static final long serialVersionUID = 1L;
    private final AbstractReplicationPacketSingleEntryData _data;
    private final String _uid;
    private final ReplicationOperationType _operationType;
    private final int _objectType;
    private final ITimeToLiveUpdateCallback _timeToLiveCallback;

    public ReplicationFilterUidDataWrapper(AbstractReplicationPacketSingleEntryData data, String uid, ITypeDesc typeDesc, ReplicationOperationType operationType, int objectType, ITimeToLiveUpdateCallback timeToLiveCallback) {
        super(typeDesc);
        this._data = data;
        this._uid = uid;
        this._operationType = operationType;
        this._objectType = objectType;
        this._timeToLiveCallback = timeToLiveCallback;
    }

    protected AbstractReplicationPacketSingleEntryData getData() {
        return this._data;
    }

    @Override
    public void discard() {
        this._data.clear();
    }

    @Override
    public int getObjectType() {
        return this._objectType;
    }

    @Override
    public ReplicationOperationType getOperationType() {
        return this._operationType;
    }

    @Override
    public boolean isDiscarded() {
        return this._data.isEmpty();
    }

    @Override
    public void setFieldsValues(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimeToLive(long time) {
        if (this._timeToLiveCallback != null) {
            this._timeToLiveCallback.updateTimeToLive(time);
        }
    }

    @Override
    public MarshalledObject getHandback() {
        return null;
    }

    @Override
    public int getNotifyType() {
        return 0;
    }

    @Override
    public Object getObject(IJSpace space) throws UnusableEntryException {
        throw new UnsupportedOperationException("getObject() is not supported for " + (Object)((Object)this._operationType));
    }

    @Override
    public Object getFieldValue(int position) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] getFieldsValues() {
        return null;
    }

    @Override
    public Map.Entry getMapEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeToLive() {
        if (this._timeToLiveCallback == null) {
            return 0L;
        }
        return this._timeToLiveCallback.getTimeToLive();
    }

    @Override
    public String getUID() {
        return this._uid;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isTransient() {
        return this._data.isTransient();
    }

    @Override
    public Object setFieldValue(String fieldName, Object value) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setFieldValue(int position, Object value) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getFieldValue(String fieldName) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ReplicationFilterUidDataWrapper [" + this._data + "]";
    }
}

