/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.j_spaces.core.OperationID;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import net.jini.core.transaction.server.ServerTransaction;

public abstract class AbstractPrepareDependentTransactionReplicationPacketData
extends AbstractTransactionReplicationPacketData {
    private static final long serialVersionUID = 1L;
    private OperationID _operationId;

    public AbstractPrepareDependentTransactionReplicationPacketData() {
    }

    public AbstractPrepareDependentTransactionReplicationPacketData(ServerTransaction transaction, OperationID operationID, boolean fromGateway) {
        super(transaction, fromGateway);
        this._operationId = operationID;
    }

    @Override
    public boolean supportsReplicationFilter() {
        return false;
    }

    protected boolean attachPrepareContent(ReplicationPacketDataMediator dataMediator) {
        if (dataMediator == null) {
            throw new IllegalStateException("Attempt to add content to replicated transaction packet when there is no data mediator");
        }
        if (this.size() != 0) {
            throw new IllegalStateException("Attempt to add content to replicated transaction packet which already has content");
        }
        ServerTransaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("Attempt to add content to replicated transaction packet which has no server transaction");
        }
        List<IReplicationTransactionalPacketEntryData> pendingTransactionData = dataMediator.removePendingTransactionData(transaction);
        if (pendingTransactionData == null) {
            return false;
        }
        for (IReplicationTransactionalPacketEntryData entryData : pendingTransactionData) {
            this.add(entryData);
        }
        return true;
    }

    @Override
    public OperationID getOperationID() {
        return this._operationId;
    }

    @Override
    protected String getCustomToString() {
        return super.getCustomToString() + "OperationID=" + this.getOperationID() + ", ";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeTransaction(out);
        IOUtils.writeObject(out, this._operationId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.readTransaction(in);
        this._operationId = (OperationID)IOUtils.readObject(in);
    }
}

