/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.view.EntryPacketServerEntryAdapter;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.ExternalizableServerEntry;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractReplicationPacketSingleEntryData
implements IExecutableReplicationPacketData<IReplicationPacketEntryData>,
IReplicationPacketEntryData {
    private static final long serialVersionUID = 1L;
    private boolean _fromGateway;
    private int _blobstoreBulkdId;
    private static final int FLAGS_GATEWAY = 1;
    private static final int FLAGS_BLOBSTORE_BULK = 2;
    private transient int _weight;
    private transient boolean _removed;

    public AbstractReplicationPacketSingleEntryData() {
    }

    @Override
    public boolean isPartOfBlobstoreBulk() {
        return this._blobstoreBulkdId != 0;
    }

    public void setBlobstoreBulkId(int blobStoreBulkReplicationId) {
        this._blobstoreBulkdId = blobStoreBulkReplicationId;
    }

    public int getBlobstoreBulkId() {
        return this._blobstoreBulkdId;
    }

    public AbstractReplicationPacketSingleEntryData(boolean fromGateway) {
        this._fromGateway = fromGateway;
    }

    @Override
    public boolean isFromGateway() {
        return this._fromGateway;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.buildFlags());
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0) && this.isPartOfBlobstoreBulk()) {
            out.writeInt(this._blobstoreBulkdId);
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._fromGateway) {
            flags = (short)(flags | 1);
        }
        if (this.isPartOfBlobstoreBulk()) {
            flags = (short)(flags | 2);
        }
        return flags;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        boolean bl = this._fromGateway = (flags & 1) != 0;
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0) && (flags & 2) != 0) {
            this._blobstoreBulkdId = in.readInt();
        }
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        out.writeShort(this.buildFlags());
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0) && this.isPartOfBlobstoreBulk()) {
            out.writeInt(this._blobstoreBulkdId);
        }
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        boolean bl = this._fromGateway = (flags & 1) != 0;
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0) && (flags & 2) != 0) {
            this._blobstoreBulkdId = in.readInt();
        }
    }

    @Override
    public boolean isSingleEntryData() {
        return true;
    }

    @Override
    public IReplicationPacketEntryData getSingleEntryData() {
        if (this._removed) {
            return null;
        }
        return this;
    }

    @Override
    public boolean add(IReplicationPacketEntryData o) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends IReplicationPacketEntryData> c) {
        return false;
    }

    @Override
    public void clear() {
        this._removed = true;
    }

    @Override
    public boolean contains(Object o) {
        return !this._removed && o == this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this._removed;
    }

    @Override
    public Iterator<IReplicationPacketEntryData> iterator() {
        return new SingleEntryIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (o == this) {
            this._removed = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.contains(this)) {
            this._removed = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this._removed) {
            return false;
        }
        return !c.contains(this);
    }

    @Override
    public int size() {
        return this._removed ? 0 : 1;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this._removed) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    public AbstractReplicationPacketSingleEntryData clone() {
        try {
            return (AbstractReplicationPacketSingleEntryData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean supportsReplicationFilter() {
        return true;
    }

    @Override
    public boolean requiresRecoveryDuplicationProtection() {
        return true;
    }

    @Override
    public boolean requiresRecoveryFiltering() {
        return false;
    }

    @Override
    public Iterable<IReplicationFilterEntry> toFilterEntries(SpaceTypeManager spaceTypeManager) {
        return new SingleFilterIterable(this.toFilterEntry(spaceTypeManager));
    }

    protected abstract IReplicationFilterEntry toFilterEntry(SpaceTypeManager var1);

    public abstract IEntryData getMainEntryData();

    public abstract IEntryData getSecondaryEntryData();

    public String getMainTypeName() {
        IEntryData mainServerEntry = this.getMainEntryData();
        if (mainServerEntry != null && mainServerEntry.getSpaceTypeDescriptor() != null) {
            return mainServerEntry.getSpaceTypeDescriptor().getTypeName();
        }
        return null;
    }

    @Override
    public IExecutableReplicationPacketData<IReplicationPacketEntryData> createEmptyMultipleEntryData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OperationID getOperationId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMultiParticipantData() {
        return false;
    }

    @Override
    public ReplicationMultipleOperationType getMultipleOperationType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getRecoveryFilteringId() {
        throw new UnsupportedOperationException();
    }

    public Object getCustomContent() {
        return null;
    }

    public long updateTimeToLiveIfNeeded(long expirationTime, long currentTimeToLive) {
        if (expirationTime == Long.MAX_VALUE) {
            return currentTimeToLive;
        }
        long updatedTimeToLive = expirationTime - SystemTime.timeMillis();
        if (updatedTimeToLive <= 0L) {
            updatedTimeToLive = Math.min(10000L, currentTimeToLive);
        }
        return updatedTimeToLive;
    }

    protected void serializeEntryData(IEntryData entryData, ObjectOutput out) throws IOException {
        if (entryData instanceof ExternalizableServerEntry || entryData instanceof EntryPacketServerEntryAdapter) {
            IOUtils.writeObject(out, entryData);
        } else if (entryData == null) {
            IOUtils.writeObject(out, entryData);
        } else {
            IOUtils.writeObject(out, new ExternalizableServerEntry(entryData));
        }
    }

    protected IEntryData deserializeEntryData(ObjectInput in) throws IOException, ClassNotFoundException {
        return (IEntryData)IOUtils.readObject(in);
    }

    @Override
    public void setWeight(int weight) {
        this._weight = weight;
    }

    @Override
    public int getWeight() {
        return this._weight;
    }

    public static class SingleFilterIterable
    implements Iterable<IReplicationFilterEntry>,
    Iterator<IReplicationFilterEntry> {
        private final IReplicationFilterEntry _filterEntry;
        private boolean _moved;

        public SingleFilterIterable(IReplicationFilterEntry filterEntry) {
            this._filterEntry = filterEntry;
        }

        @Override
        public Iterator<IReplicationFilterEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return !this._moved;
        }

        @Override
        public IReplicationFilterEntry next() {
            if (this._moved) {
                throw new NoSuchElementException();
            }
            this._moved = true;
            return this._filterEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class SingleEntryIterator
    implements Iterator<IReplicationPacketEntryData> {
        private boolean _nextCalled;

        @Override
        public boolean hasNext() {
            if (AbstractReplicationPacketSingleEntryData.this._removed) {
                return false;
            }
            return !this._nextCalled;
        }

        @Override
        public IReplicationPacketEntryData next() {
            if (this._nextCalled) {
                throw new NoSuchElementException();
            }
            this._nextCalled = true;
            return AbstractReplicationPacketSingleEntryData.this;
        }

        @Override
        public void remove() {
            AbstractReplicationPacketSingleEntryData.this._removed = true;
        }
    }
}

