/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ISwapExternalizable;
import com.gigaspaces.transaction.TransactionUniqueId;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

public abstract class AbstractTransactionReplicationPacketData
extends LinkedList<IReplicationTransactionalPacketEntryData>
implements IExecutableReplicationPacketData<IReplicationTransactionalPacketEntryData>,
ITransactionInContext {
    private static final long serialVersionUID = 1L;
    private TransactionParticipantDataImpl _metaData;
    private ServerTransaction _transaction;
    private static final short FLAGS_GATEWAY = 1;
    private static final short HAS_TRANSIENT_MEMBERS = 2;
    private static final short HAS_PERSISTENT_MEMBERS = 4;
    private transient int _weight;
    private transient short _flags;

    public AbstractTransactionReplicationPacketData() {
    }

    public AbstractTransactionReplicationPacketData(ServerTransaction transaction, boolean fromGateway) {
        this(fromGateway);
        this._transaction = transaction;
        this._metaData = this._transaction.getMetaData();
    }

    public AbstractTransactionReplicationPacketData(boolean fromGateway) {
        if (fromGateway) {
            this._flags = (short)(this._flags | 1);
        }
    }

    @Override
    public OperationID getOperationID() {
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._flags = in.readShort();
        this._metaData = (TransactionParticipantDataImpl)IOUtils.readObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this._flags);
        IOUtils.writeObject(out, this._metaData);
    }

    protected void writeTransaction(ObjectOutput out) throws IOException {
        IOUtils.writeWithCachedStubs(out, this._transaction);
    }

    void readTransaction(ObjectInput in) throws IOException, ClassNotFoundException {
        this._transaction = (ServerTransaction)IOUtils.readWithCachedStubs(in);
    }

    void writeTransactionData(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (IReplicationTransactionalPacketEntryData entryData : this) {
            IOUtils.writeObject(out, entryData);
        }
    }

    void readTransactionData(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            IReplicationTransactionalPacketEntryData entryData = (IReplicationTransactionalPacketEntryData)IOUtils.readObject(in);
            this.add(entryData);
        }
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this._flags = in.readShort();
        this._metaData = (TransactionParticipantDataImpl)IOUtils.readNullableSwapExternalizableObject(in);
        this._transaction = (ServerTransaction)IOUtils.readNullableSwapExternalizableObject(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            IReplicationTransactionalPacketEntryData entryData = (IReplicationTransactionalPacketEntryData)IOUtils.readSwapExternalizableObject(in);
            this.add(entryData);
        }
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        out.writeShort(this._flags);
        IOUtils.writeNullableSwapExternalizableObject(out, (ISwapExternalizable)this._metaData);
        IOUtils.writeNullableSwapExternalizableObject(out, (ISwapExternalizable)this._transaction);
        out.writeInt(this.size());
        for (IReplicationTransactionalPacketEntryData entryData : this) {
            IOUtils.writeSwapExternalizableObject(out, entryData);
        }
    }

    @Override
    public IExecutableReplicationPacketData<IReplicationTransactionalPacketEntryData> clone() {
        IExecutableReplicationPacketData<IReplicationTransactionalPacketEntryData> clone = this.createEmptyMultipleEntryData();
        for (IReplicationTransactionalPacketEntryData entryData : this) {
            clone.add(entryData.clone());
        }
        return clone;
    }

    @Override
    public boolean isSingleEntryData() {
        return false;
    }

    @Override
    public boolean isFromGateway() {
        return (this._flags & 1) != 0;
    }

    @Override
    public IReplicationPacketEntryData getSingleEntryData() {
        throw new UnsupportedOperationException();
    }

    public void setMetaData(TransactionParticipantDataImpl metaData) {
        this._metaData = metaData;
    }

    @Override
    public TransactionParticipantDataImpl getMetaData() {
        return this._metaData;
    }

    @Override
    public ServerTransaction getTransaction() {
        return this._transaction;
    }

    @Override
    public boolean beforeDelayedReplication() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IReplicationTransactionalPacketEntryData type = (IReplicationTransactionalPacketEntryData)iterator.next();
            boolean stillRelevant = type.beforeDelayedReplication();
            if (stillRelevant) continue;
            iterator.remove();
        }
        return !this.isEmpty();
    }

    @Override
    public Iterable<IReplicationFilterEntry> toFilterEntries(SpaceTypeManager spaceTypeManager) {
        return new FilterIterable(this.iterator(), spaceTypeManager);
    }

    @Override
    public String toString() {
        TransactionUniqueId transactionId = this.getMetaData() != null ? this.getMetaData().getTransactionUniqueId() : null;
        String transactionIdAddition = transactionId != null ? "ID=" + transactionId + ", " : "";
        return "TRANSACTION [" + transactionIdAddition + this.getCustomToString() + (Object)((Object)this.getMultipleOperationType()) + "]: " + super.toString();
    }

    protected String getCustomToString() {
        return "";
    }

    public void setHasTransientMembersFlag() {
        this._flags = (short)(this._flags | 2);
    }

    public void unsetHasTransientMembersFlag() {
        this._flags = (short)(this._flags & 0xFFFFFFFD);
    }

    public void setHasPersistentMembersFlag() {
        this._flags = (short)(this._flags | 4);
    }

    public boolean hasTransientMembers() {
        return (this._flags & 2) != 0;
    }

    public boolean hasPersistentMembers() {
        return (this._flags & 4) != 0;
    }

    @Override
    public Object getRecoveryFilteringId() {
        return this._transaction;
    }

    @Override
    public void setWeight(int weight) {
        this._weight = weight;
    }

    @Override
    public int getWeight() {
        return this._weight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTransactionReplicationPacketData that = (AbstractTransactionReplicationPacketData)o;
        if (this._weight != that._weight) {
            return false;
        }
        if (this._flags != that._flags) {
            return false;
        }
        if (this._metaData != null ? !this._metaData.equals((Object)that._metaData) : that._metaData != null) {
            return false;
        }
        return this._transaction != null ? this._transaction.equals((Object)that._transaction) : that._transaction == null;
    }

    public static class FilterIterable
    implements Iterable<IReplicationFilterEntry>,
    Iterator<IReplicationFilterEntry> {
        private final Iterator<IReplicationTransactionalPacketEntryData> _iterator;
        private final SpaceTypeManager _spaceTypeManager;
        private IReplicationFilterEntry _lastFilterEntry;

        FilterIterable(Iterator<IReplicationTransactionalPacketEntryData> iterator, SpaceTypeManager spaceTypeManager) {
            this._iterator = iterator;
            this._spaceTypeManager = spaceTypeManager;
        }

        @Override
        public Iterator<IReplicationFilterEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.removePreviousDiscardedIfNeeded();
            return this._iterator.hasNext();
        }

        @Override
        public IReplicationFilterEntry next() {
            this.removePreviousDiscardedIfNeeded();
            IReplicationTransactionalPacketEntryData next = this._iterator.next();
            this._lastFilterEntry = next.toFilterEntry(this._spaceTypeManager);
            return this._lastFilterEntry;
        }

        private void removePreviousDiscardedIfNeeded() {
            if (this._lastFilterEntry != null && this._lastFilterEntry.isDiscarded()) {
                this._iterator.remove();
                this._lastFilterEntry = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

