/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationInContentContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ChangeReplicationFilterUidDataWrapper;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ITimeToLiveUpdateCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleUidReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

@InternalApi
public class ChangeReplicationPacketData
extends SingleUidReplicationPacketData
implements IReplicationTransactionalPacketEntryData,
ITimeToLiveUpdateCallback {
    private static final long serialVersionUID = 1L;
    private static final String ChangeReplicationPacketData = null;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.internal.cluster.node.impl.packets.data.operations.ChangeReplicationPacketData");
    private transient long _expirationTime;
    private transient IEntryData _previousEntryData;
    private int _routingHash;
    private Collection<SpaceEntryMutator> _spaceEntryMutators;
    private long _timeToLive;
    private String _typeName;
    private Object _id;
    private int _version;
    private int _previousVersion;
    public static final ThreadLocal<Boolean> forRecovery = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return false;
        }
    };
    private static final byte FLAGS_TIME_TO_LIVE = 1;
    private static final byte FLAGS_PREVIOUS_VERSION = 2;
    private static final byte FLAGS_ID = 4;
    private static final long DEFAULT_TIME_TO_LIVE = Long.MAX_VALUE;

    public ChangeReplicationPacketData() {
    }

    public ChangeReplicationPacketData(String typeName, String uid, Object id, int version, int previousVersion, boolean isTransient, IEntryData entryData, OperationID operationID, int routingHash, Collection<SpaceEntryMutator> spaceEntryMutators, IEntryData previousEntryData, long timeToLive, long expirationTime, boolean fromGateway) {
        super(uid, operationID, isTransient, fromGateway, entryData);
        this._typeName = typeName;
        this._id = id;
        this._version = version;
        this._previousVersion = previousVersion;
        this._routingHash = routingHash;
        this._spaceEntryMutators = spaceEntryMutators;
        this._previousEntryData = previousEntryData;
        this._timeToLive = timeToLive;
        this._expirationTime = expirationTime;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.CHANGE;
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTransactional(IReplicationInContext context, ITransactionalExecutionCallback transactionExecutionCallback, Transaction transaction, boolean twoPhaseCommit) throws Exception {
        try {
            transactionExecutionCallback.changeEntry(context, transaction, twoPhaseCommit, this.getTypeName(), this.getUid(), this._id, this._version, this._previousVersion, this._timeToLive, this._routingHash, this._spaceEntryMutators, this.isTransient(), this.getOperationId(), this._previousEntryData);
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null) {
                if (contentContext.getMainEntryData() != null) {
                    this._entryData = contentContext.getMainEntryData();
                }
                if (contentContext.getSecondaryEntryData() != null) {
                    this._previousEntryData = contentContext.getSecondaryEntryData();
                }
                contentContext.clear();
            }
        }
    }

    @Override
    public void batchExecuteTransactional(IReplicationInBatchContext context, ITransactionalBatchExecutionCallback transactionExecutionCallback) throws Exception {
        transactionExecutionCallback.changeEntry(context, this.getTypeName(), this.getUid(), this._id, this._version, this._previousVersion, this._timeToLive, this._routingHash, this._spaceEntryMutators, this.isTransient(), this.getOperationId());
    }

    @Override
    public boolean beforeDelayedReplication() {
        this._timeToLive = this.updateTimeToLiveIfNeeded(this._expirationTime, this._timeToLive);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl(IReplicationInContext context, IReplicationInFacade inReplicationHandler) throws Exception {
        try {
            inReplicationHandler.inChangeEntry(context, this.getTypeName(), this.getUid(), this._id, this._version, this._previousVersion, this._routingHash, this._timeToLive, this._spaceEntryMutators, this.isTransient(), this.getOperationId());
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null && contentContext.getSecondaryEntryData() != null) {
                this._previousEntryData = contentContext.getSecondaryEntryData();
            }
        }
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    protected int getFilterObjectType() {
        return 1;
    }

    @Override
    public boolean supportsReplicationFilter() {
        return true;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = this.getTypeDescriptor(spaceTypeManager);
        ITypeDesc typeDesc = serverTypeDesc == null ? null : serverTypeDesc.getTypeDesc();
        return new ChangeReplicationFilterUidDataWrapper(this, this.getUid(), typeDesc, this.getFilterOldReplicationOpType(), this.getFilterObjectType(), this.getTimeToLiveUpdateCallback(), this._version, this._spaceEntryMutators, this._id);
    }

    @Override
    protected ReplicationOperationType getFilterOldReplicationOpType() {
        return ReplicationOperationType.CHANGE;
    }

    @Override
    protected ITimeToLiveUpdateCallback getTimeToLiveUpdateCallback() {
        return this;
    }

    @Override
    public void updateTimeToLive(long newTimeToLive) {
        this._timeToLive = newTimeToLive;
    }

    @Override
    public long getTimeToLive() {
        return this._timeToLive;
    }

    @Override
    public IEntryData getSecondaryEntryData() {
        return this._previousEntryData;
    }

    @Override
    public boolean containsFullEntryData() {
        return true;
    }

    @Override
    public Collection<SpaceEntryMutator> getCustomContent() {
        return this._spaceEntryMutators;
    }

    @Override
    public ChangeReplicationPacketData clone() {
        ChangeReplicationPacketData clone = (ChangeReplicationPacketData)super.clone();
        LinkedList<SpaceEntryMutator> clonedMutators = new LinkedList<SpaceEntryMutator>();
        for (SpaceEntryMutator spaceEntryMutator : this._spaceEntryMutators) {
            clonedMutators.add(spaceEntryMutator);
        }
        clone._spaceEntryMutators = clonedMutators;
        return clone;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeExternalImpl(out, LRMIInvocationContext.getEndpointLogicalVersion());
        if (forRecovery.get().booleanValue()) {
            _logger.fine("Serializing packet data " + this + " with full entryData due to recovery process");
            this.serializeEntryData(this._entryData, out);
        }
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this._timeToLive != Long.MAX_VALUE) {
            flags = (byte)(flags | 1);
        }
        if (this._previousVersion != 0) {
            flags = (byte)(flags | 2);
        }
        if (!this.getUid().equals(this._id)) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    private final void writeExternalImpl(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            byte flags = this.buildFlags();
            out.writeByte(flags);
            IOUtils.writeRepetitiveString(out, this._typeName);
            out.writeInt(this._version);
            out.writeInt(this._routingHash);
            IOUtils.writeObject(out, this._spaceEntryMutators);
            if ((flags & 1) != 0) {
                out.writeLong(this._timeToLive);
            }
            if ((flags & 2) != 0) {
                out.writeInt(this._previousVersion);
            }
            if ((flags & 4) != 0) {
                IOUtils.writeObject(out, this._id);
            }
        } else {
            IOUtils.writeRepetitiveString(out, this._typeName);
            out.writeInt(this._version);
            out.writeInt(this._routingHash);
            out.writeLong(this._timeToLive);
            IOUtils.writeObject(out, this._spaceEntryMutators);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.readExternalImpl(in, LRMIInvocationContext.getEndpointLogicalVersion());
        long l = this._expirationTime = this._timeToLive != Long.MAX_VALUE ? this._timeToLive + SystemTime.timeMillis() : Long.MAX_VALUE;
        if (forRecovery.get().booleanValue()) {
            this._entryData = this.deserializeEntryData(in);
        }
    }

    private void readExternalImpl(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            byte flags = in.readByte();
            this._typeName = IOUtils.readRepetitiveString(in);
            this._version = in.readInt();
            this._routingHash = in.readInt();
            this._spaceEntryMutators = (Collection)IOUtils.readObject(in);
            this._timeToLive = (flags & 1) != 0 ? in.readLong() : Long.MAX_VALUE;
            this._previousVersion = (flags & 2) != 0 ? in.readInt() : 0;
            this._id = (flags & 4) != 0 ? IOUtils.readObject(in) : this.getUid();
        } else {
            this._typeName = IOUtils.readRepetitiveString(in);
            this._version = in.readInt();
            this._routingHash = in.readInt();
            this._timeToLive = in.readLong();
            this._spaceEntryMutators = (Collection)IOUtils.readObject(in);
        }
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.writeExternalImpl(out, PlatformLogicalVersion.getLogicalVersion());
        out.writeLong(this._expirationTime);
        this.serializeEntryData(this._previousEntryData, out);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.readExternalImpl(in, PlatformLogicalVersion.getLogicalVersion());
        this._expirationTime = in.readLong();
        this._previousEntryData = this.deserializeEntryData(in);
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }

    public String toString() {
        return "CHANGE: (typeName=" + this.getTypeName() + " uid=" + this.getUid() + " operationID=" + this.getOperationId() + " version=" + this._version + " mutators=" + this._spaceEntryMutators + ")";
    }
}

