/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleUidReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class EntryLeaseExpiredReplicationPacketData
extends SingleUidReplicationPacketData {
    private static final long serialVersionUID = 1L;
    private String _className;

    public EntryLeaseExpiredReplicationPacketData() {
    }

    public EntryLeaseExpiredReplicationPacketData(String className, String uid, boolean isTransient, IEntryData entryData, OperationID operationID) {
        super(uid, operationID, isTransient, false, entryData);
        this._className = className;
    }

    @Override
    public String getTypeName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeRepetitiveString(out, this._className);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._className = IOUtils.readRepetitiveString(in);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeString(out, this._className);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._className = IOUtils.readString(in);
    }

    @Override
    protected void executeImpl(IReplicationInContext context, IReplicationInFacade inReplicationHandler) throws Exception {
        inReplicationHandler.inEntryLeaseExpiredByUID(context, this.getTypeName(), this.getUid(), this.isTransient(), this.getOperationId());
    }

    @Override
    public boolean beforeDelayedReplication() {
        return true;
    }

    @Override
    protected ReplicationOperationType getFilterOldReplicationOpType() {
        return ReplicationOperationType.LEASE_EXPIRATION;
    }

    @Override
    protected int getFilterObjectType() {
        return 1;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.ENTRY_LEASE_EXPIRED;
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    public String toString() {
        return "ENTRY LEASE EXPIRED: (class name=" + this.getTypeName() + " uid=" + this.getUid() + ")";
    }
}

