/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.handlers.UnknownEntryLeaseException;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ITimeToLiveUpdateCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleUidReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.lease.UnknownLeaseException;

@InternalApi
public class ExtendEntryLeaseReplicationPacketData
extends SingleUidReplicationPacketData
implements ITimeToLiveUpdateCallback {
    private static final long serialVersionUID = 1L;
    private String _className;
    private long _leaseTime;
    private int _routingHash;
    private transient long _expirationTime;

    public ExtendEntryLeaseReplicationPacketData() {
    }

    public ExtendEntryLeaseReplicationPacketData(String className, String uid, boolean isTransient, IEntryData entryData, long expirationTime, long leaseTime, OperationID operationID, int routingHash, boolean isFromGateway) {
        super(uid, operationID, isTransient, isFromGateway, entryData);
        this._className = className;
        this._expirationTime = expirationTime;
        this._leaseTime = leaseTime;
        this._routingHash = routingHash;
    }

    @Override
    protected void executeImpl(IReplicationInContext context, IReplicationInFacade inReplicationHandler) throws Exception {
        try {
            inReplicationHandler.inExtendEntryLeasePeriod(context, this._className, this.getUid(), this.isTransient(), this._leaseTime, this._routingHash);
        }
        catch (UnknownLeaseException ex) {
            throw new UnknownEntryLeaseException(this._className, this.getUid(), this.getOperationId(), ex);
        }
    }

    @Override
    public boolean beforeDelayedReplication() {
        if (this._expirationTime != Long.MAX_VALUE) {
            long updatedTimeToLive = this._expirationTime - SystemTime.timeMillis();
            if (updatedTimeToLive <= 0L) {
                return false;
            }
            this._leaseTime = updatedTimeToLive;
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._className = IOUtils.readRepetitiveString(in);
        this._leaseTime = in.readLong();
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            this._routingHash = in.readInt();
        }
        this._expirationTime = this._leaseTime != Long.MAX_VALUE ? this._leaseTime + SystemTime.timeMillis() : Long.MAX_VALUE;
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._className = IOUtils.readRepetitiveString(in);
        this._leaseTime = in.readLong();
        this._routingHash = in.readInt();
        this._expirationTime = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeRepetitiveString(out, this._className);
        out.writeLong(this._leaseTime);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            out.writeInt(this._routingHash);
        }
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeRepetitiveString(out, this._className);
        out.writeLong(this._leaseTime);
        out.writeInt(this._routingHash);
        out.writeLong(this._expirationTime);
    }

    @Override
    protected String getTypeName() {
        return this._className;
    }

    @Override
    protected ReplicationOperationType getFilterOldReplicationOpType() {
        return ReplicationOperationType.EXTEND_LEASE;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.EXTEND_ENTRY_LEASE;
    }

    @Override
    protected int getFilterObjectType() {
        return 1;
    }

    @Override
    protected ITimeToLiveUpdateCallback getTimeToLiveUpdateCallback() {
        return this;
    }

    @Override
    public void updateTimeToLive(long newTimeToLive) {
        this._leaseTime = newTimeToLive;
    }

    @Override
    public long getTimeToLive() {
        return this._leaseTime;
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    public String toString() {
        return "EXTEND ENTRY LEASE: (class name=" + this.getTypeName() + " uid=" + this.getUid() + " leaseTime=" + this._leaseTime + ")";
    }
}

