/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.handlers.UnknownNotifyTemplateLeaseException;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ITimeToLiveUpdateCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.NotifyReplicationFilterUidDataWrapper;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleUidReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.lease.UnknownLeaseException;

@InternalApi
public class ExtendNotifyTemplateLeaseReplicationPacketData
extends SingleUidReplicationPacketData
implements ITimeToLiveUpdateCallback {
    private static final long serialVersionUID = 1L;
    private String _className;
    private long _leaseTime;
    private transient long _expirationTime;
    private transient int _objectType;
    private transient NotifyInfo _notifyInfo;

    public ExtendNotifyTemplateLeaseReplicationPacketData() {
    }

    public ExtendNotifyTemplateLeaseReplicationPacketData(String className, String uid, boolean isTransient, IEntryData entryData, long expirationTime, long leaseTime, int objectType, NotifyInfo notifyInfo, OperationID operationID) {
        super(uid, operationID, isTransient, false, entryData);
        this._className = className;
        this._expirationTime = expirationTime;
        this._leaseTime = leaseTime;
        this._objectType = objectType;
        this._notifyInfo = notifyInfo;
    }

    @Override
    protected void executeImpl(IReplicationInContext context, IReplicationInFacade inReplicationHandler) throws Exception {
        try {
            inReplicationHandler.inExtendNotifyTemplateLeasePeriod(context, this._className, this.getUid(), this._leaseTime);
        }
        catch (UnknownLeaseException ex) {
            throw new UnknownNotifyTemplateLeaseException(this._className, this.getUid(), ex);
        }
    }

    @Override
    public boolean beforeDelayedReplication() {
        if (this._expirationTime != Long.MAX_VALUE) {
            long updatedTimeToLive = this._expirationTime - SystemTime.timeMillis();
            if (updatedTimeToLive <= 0L) {
                return false;
            }
            this._leaseTime = updatedTimeToLive;
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.readExternalImpl(in);
    }

    private void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        this._className = IOUtils.readRepetitiveString(in);
        this._leaseTime = in.readLong();
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.readExternalImpl(in);
        this._expirationTime = in.readLong();
        this._objectType = in.readInt();
        this._notifyInfo = (NotifyInfo)IOUtils.readNullableSwapExternalizableObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeExternalImpl(out);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.writeExternalImpl(out);
        out.writeLong(this._expirationTime);
        out.writeInt(this._objectType);
        IOUtils.writeNullableSwapExternalizableObject(out, this._notifyInfo);
    }

    private void writeExternalImpl(ObjectOutput out) throws IOException {
        IOUtils.writeRepetitiveString(out, this._className);
        out.writeLong(this._leaseTime);
    }

    @Override
    protected String getTypeName() {
        return this._className;
    }

    @Override
    protected IReplicationFilterEntry toFilterEntry(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = this.getTypeDescriptor(spaceTypeManager);
        ITypeDesc typeDesc = serverTypeDesc == null ? null : serverTypeDesc.getTypeDesc();
        return new NotifyReplicationFilterUidDataWrapper(this, this.getUid(), typeDesc, this.getFilterOldReplicationOpType(), this.getFilterObjectType(), this._notifyInfo, this.getTimeToLiveUpdateCallback());
    }

    @Override
    protected ReplicationOperationType getFilterOldReplicationOpType() {
        return ReplicationOperationType.EXTEND_LEASE;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.EXTEND_NOTIFY_TEMPLATE_LEASE;
    }

    @Override
    protected int getFilterObjectType() {
        return this._objectType;
    }

    @Override
    protected ITimeToLiveUpdateCallback getTimeToLiveUpdateCallback() {
        return this;
    }

    @Override
    public void updateTimeToLive(long newTimeToLive) {
        this._leaseTime = newTimeToLive;
    }

    @Override
    public long getTimeToLive() {
        return this._leaseTime;
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    public String toString() {
        return "EXTEND NOTIFY TEMPLATE LEASE: (class name=" + this.getTypeName() + " uid=" + this.getUid() + " leaseTime=" + this._leaseTime + ")";
    }
}

