/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.NotifyReplicationFilterEntryDataWrapper;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class InsertNotifyTemplateReplicationPacketData
extends SingleReplicationPacketData {
    private static final long serialVersionUID = 1L;
    private NotifyInfo _notifyInfo;
    private String _templateUid;
    private transient long _expirationTime;

    public InsertNotifyTemplateReplicationPacketData() {
    }

    public InsertNotifyTemplateReplicationPacketData(ITemplatePacket templatePacket, String templateUid, NotifyInfo notifyInfo, long expirationTime) {
        super(templatePacket, false);
        this._templateUid = templateUid;
        this._notifyInfo = notifyInfo;
        this._expirationTime = expirationTime;
    }

    public NotifyInfo getNotifyInfo() {
        return this._notifyInfo;
    }

    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        inReplicationHandler.inInsertNotifyTemplate(context, (ITemplatePacket)this.getEntryPacket(), this._templateUid, this.getNotifyInfo());
    }

    @Override
    public boolean beforeDelayedReplication() {
        if (this._expirationTime != Long.MAX_VALUE) {
            long updatedTimeToLive = this._expirationTime - SystemTime.timeMillis();
            if (updatedTimeToLive <= 0L) {
                return false;
            }
            this.getEntryPacket().setTTL(updatedTimeToLive);
        }
        return true;
    }

    @Override
    public String getUid() {
        return this._templateUid;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._notifyInfo);
        IOUtils.writeString(out, this._templateUid);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeNullableSwapExternalizableObject(out, this._notifyInfo);
        IOUtils.writeString(out, this._templateUid);
        out.writeLong(this._expirationTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._notifyInfo = (NotifyInfo)IOUtils.readObject(in);
        this._templateUid = IOUtils.readString(in);
        this._expirationTime = !this.getEntryPacket().isExternalizableEntryPacket() && this.getEntryPacket().getTTL() != Long.MAX_VALUE ? this.getEntryPacket().getTTL() + SystemTime.timeMillis() : Long.MAX_VALUE;
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._notifyInfo = (NotifyInfo)IOUtils.readNullableSwapExternalizableObject(in);
        this._templateUid = IOUtils.readString(in);
        this._expirationTime = in.readLong();
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = this.getTypeDescriptor(spaceTypeManager);
        ITypeDesc typeDesc = serverTypeDesc.getTypeDesc();
        return new NotifyReplicationFilterEntryDataWrapper((AbstractReplicationPacketSingleEntryData)this, this.getEntryPacket(), typeDesc, this.getFilterObjectType(serverTypeDesc), this.getNotifyInfo());
    }

    @Override
    protected int getFilterObjectType(IServerTypeDesc serverTypeDesc) {
        return serverTypeDesc.isRootType() ? 5 : 3;
    }

    @Override
    protected ReplicationOperationType getFilterReplicationOpType() {
        return ReplicationOperationType.NOTIFY;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.INSERT_NOTIFY_TEMPLATE;
    }

    public String toString() {
        return "INSERT NOTIFY TEMPLATE: " + this.getEntryPacket();
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return false;
    }
}

