/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationInContentContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleUidReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.transaction.Transaction;

@InternalApi
public class RemoveByUIDReplicationPacketData
extends SingleUidReplicationPacketData
implements IReplicationTransactionalPacketEntryData {
    private static final long serialVersionUID = 1L;
    private String _typeName;

    public RemoveByUIDReplicationPacketData() {
    }

    public RemoveByUIDReplicationPacketData(String typeName, String uid, boolean isTransient, IEntryData entryData, OperationID operationID, boolean fromGateway) {
        super(uid, operationID, isTransient, fromGateway, entryData);
        this._typeName = typeName;
    }

    @Override
    protected void executeImpl(IReplicationInContext context, IReplicationInFacade inReplicationHandler) throws Exception {
        inReplicationHandler.inRemoveEntryByUID(context, this._typeName, this.getUid(), this.isTransient(), this.getOperationId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTransactional(IReplicationInContext context, ITransactionalExecutionCallback transactionExecutionCallback, Transaction transaction, boolean twoPhaseCommit) throws Exception {
        try {
            transactionExecutionCallback.removeEntryByUID(context, transaction, twoPhaseCommit, this.getUid(), this.isTransient(), this.getOperationId());
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null) {
                this._entryData = contentContext.getMainEntryData();
                contentContext.clear();
            }
        }
    }

    @Override
    public boolean beforeDelayedReplication() {
        return true;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(SpaceTypeManager spaceTypeManager) {
        return super.toFilterEntry(spaceTypeManager);
    }

    @Override
    protected String getTypeName() {
        return this._typeName;
    }

    @Override
    public RemoveByUIDReplicationPacketData clone() {
        return (RemoveByUIDReplicationPacketData)super.clone();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeRepetitiveString(out, this._typeName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._typeName = IOUtils.readRepetitiveString(in);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeString(out, this._typeName);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._typeName = IOUtils.readString(in);
    }

    @Override
    protected ReplicationOperationType getFilterOldReplicationOpType() {
        return ReplicationOperationType.TAKE;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.REMOVE_ENTRY;
    }

    @Override
    protected int getFilterObjectType() {
        return 1;
    }

    @Override
    public void batchExecuteTransactional(IReplicationInBatchContext context, ITransactionalBatchExecutionCallback executionCallback) throws Exception {
        executionCallback.removeEntryByUID(context, this.getTypeName(), this.getUid(), this.getOperationId());
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    public String toString() {
        return "REMOVE: (uid=" + this.getUid() + ")";
    }
}

