/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.NotifyReplicationFilterUidDataWrapper;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleUidReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class RemoveNotifyTemplateReplicationPacketData
extends SingleUidReplicationPacketData {
    private static final long serialVersionUID = 1L;
    private String _className;
    private transient NotifyInfo _notifyInfo;
    private transient int _objectType;

    public RemoveNotifyTemplateReplicationPacketData() {
    }

    public RemoveNotifyTemplateReplicationPacketData(String className, NotifyInfo notifyInfo, int objectType, String templateUid, boolean isTransient, IEntryData entryData, OperationID operationID) {
        super(templateUid, operationID, isTransient, false, entryData);
        this._className = className;
        this._notifyInfo = notifyInfo;
        this._objectType = objectType;
    }

    @Override
    public String getTypeName() {
        return this._className;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeRepetitiveString(out, this._className);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._className = IOUtils.readRepetitiveString(in);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeString(out, this._className);
        out.writeInt(this._objectType);
        IOUtils.writeNullableSwapExternalizableObject(out, this._notifyInfo);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._className = IOUtils.readString(in);
        this._objectType = in.readInt();
        this._notifyInfo = (NotifyInfo)IOUtils.readNullableSwapExternalizableObject(in);
    }

    @Override
    protected void executeImpl(IReplicationInContext context, IReplicationInFacade inReplicationHandler) throws Exception {
        inReplicationHandler.inRemoveNotifyTemplate(context, this.getTypeName(), this.getUid());
    }

    @Override
    public boolean beforeDelayedReplication() {
        return true;
    }

    @Override
    protected IReplicationFilterEntry toFilterEntry(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = this.getTypeDescriptor(spaceTypeManager);
        ITypeDesc typeDesc = serverTypeDesc == null ? null : serverTypeDesc.getTypeDesc();
        return new NotifyReplicationFilterUidDataWrapper(this, this.getUid(), typeDesc, this.getFilterOldReplicationOpType(), this.getFilterObjectType(), this._notifyInfo, null);
    }

    @Override
    protected ReplicationOperationType getFilterOldReplicationOpType() {
        return ReplicationOperationType.LEASE_EXPIRATION;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.REMOVE_NOTIFY_TEMPLATE;
    }

    @Override
    protected int getFilterObjectType() {
        return this._objectType;
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    public String toString() {
        return "REMOVE NOTIFY TEMPLATE: (class name=" + this.getTypeName() + " uid=" + this.getUid() + ")";
    }
}

