/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationInContentContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleReplicationPacketData;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.transaction.Transaction;

@InternalApi
public class RemoveReplicationPacketData
extends SingleReplicationPacketData
implements IReplicationTransactionalPacketEntryData {
    private static final long serialVersionUID = 1L;
    private boolean _fullEntryPacket;
    private transient IEntryData _entryData;

    public RemoveReplicationPacketData() {
    }

    @Override
    public RemoveReplicationPacketData clone() {
        return (RemoveReplicationPacketData)super.clone();
    }

    public RemoveReplicationPacketData(IEntryPacket entry, boolean fromGateway, IEntryData entryData, boolean fullEntryPacket) {
        super(entry, fromGateway);
        this._entryData = entryData;
        this._fullEntryPacket = fullEntryPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        try {
            inReplicationHandler.inRemoveEntry(context, this.getEntryPacket());
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null && contentContext.getMainEntryData() != null) {
                this._entryData = contentContext.getMainEntryData();
                contentContext.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTransactional(IReplicationInContext context, ITransactionalExecutionCallback transactionExecutionCallback, Transaction transaction, boolean twoPhaseCommit) throws Exception {
        try {
            transactionExecutionCallback.removeEntry(context, transaction, twoPhaseCommit, this.getEntryPacket());
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null && contentContext.getMainEntryData() != null) {
                this._entryData = contentContext.getMainEntryData();
                contentContext.clear();
            }
        }
    }

    @Override
    public void batchExecuteTransactional(IReplicationInBatchContext context, ITransactionalBatchExecutionCallback executionCallback) throws Exception {
        executionCallback.removeEntry(context, this.getEntryPacket());
    }

    @Override
    public boolean beforeDelayedReplication() {
        return true;
    }

    @Override
    protected int getFilterObjectType(IServerTypeDesc serverTypeDesc) {
        return 1;
    }

    @Override
    protected ReplicationOperationType getFilterReplicationOpType() {
        return ReplicationOperationType.TAKE;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.REMOVE_ENTRY;
    }

    public String toString() {
        return "REMOVE: " + this.getEntryPacket();
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    @Override
    public IEntryData getMainEntryData() {
        if (this._entryData == null && this.containsFullEntryData()) {
            return super.getMainEntryData();
        }
        return this._entryData;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            out.writeBoolean(this._fullEntryPacket);
        }
    }

    @Override
    public boolean containsFullEntryData() {
        return this._fullEntryPacket;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            this._fullEntryPacket = in.readBoolean();
        }
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        out.writeBoolean(this._fullEntryPacket);
        this.serializeEntryData(this._entryData, out);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._fullEntryPacket = in.readBoolean();
        this._entryData = this.deserializeEntryData(in);
    }
}

