/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ReplicationFilterEntryDataWrapper;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.cluster.node.impl.view.EntryPacketServerEntryAdapter;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationFilterException;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class SingleReplicationPacketData
extends AbstractReplicationPacketSingleEntryData {
    private static final long serialVersionUID = 1L;
    private IEntryPacket _entryPacket;
    private volatile transient IEntryData _entryData;

    public SingleReplicationPacketData() {
    }

    public SingleReplicationPacketData(IEntryPacket entry, boolean fromGateway) {
        super(fromGateway);
        this._entryPacket = entry;
    }

    @Override
    public SingleReplicationPacketData clone() {
        return this.cloneWithEntryPacket(this._entryPacket.clone());
    }

    public SingleReplicationPacketData cloneWithEntryPacket(IEntryPacket entryPacket) {
        SingleReplicationPacketData clone = (SingleReplicationPacketData)super.clone();
        clone._entryPacket = entryPacket;
        return clone;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._entryPacket = (IEntryPacket)in.readObject();
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._entryPacket = (IEntryPacket)IOUtils.readNullableSwapExternalizableObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._entryPacket);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeNullableSwapExternalizableObject(out, this._entryPacket);
    }

    @Override
    public String getUid() {
        return this._entryPacket.getUID();
    }

    public IEntryPacket getEntryPacket() {
        return this._entryPacket;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = this.getTypeDescriptor(spaceTypeManager);
        ITypeDesc typeDesc = serverTypeDesc.getTypeDesc();
        return new ReplicationFilterEntryDataWrapper(this, this.getEntryPacket(), typeDesc, this.getFilterReplicationOpType(), this.getFilterObjectType(serverTypeDesc));
    }

    protected IServerTypeDesc getTypeDescriptor(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = null;
        String className = this.getEntryPacket().getTypeName();
        if (className != null) {
            try {
                serverTypeDesc = spaceTypeManager.loadServerTypeDesc(this.getEntryPacket());
            }
            catch (Exception e) {
                throw new ReplicationFilterException(e.getMessage(), e);
            }
        }
        if (serverTypeDesc == null) {
            throw new ReplicationFilterException("Could not get server type descriptor for class " + className);
        }
        return serverTypeDesc;
    }

    @Override
    public int getOrderCode() {
        ITypeDesc typeDescriptor = this._entryPacket.getTypeDescriptor();
        if (typeDescriptor != null && !typeDescriptor.isInactive() && typeDescriptor.isFifoSupported()) {
            return this._entryPacket.getTypeName().hashCode();
        }
        return this.getUid().hashCode();
    }

    @Override
    public boolean isTransient() {
        return this._entryPacket.isTransient();
    }

    protected abstract int getFilterObjectType(IServerTypeDesc var1);

    protected abstract ReplicationOperationType getFilterReplicationOpType();

    @Override
    public IEntryData getMainEntryData() {
        if (this._entryData == null) {
            this._entryData = new EntryPacketServerEntryAdapter(this.getEntryPacket());
        }
        return this._entryData;
    }

    @Override
    public IEntryData getSecondaryEntryData() {
        return null;
    }

    @Override
    public OperationID getOperationId() {
        return this._entryPacket.getOperationID();
    }

    @Override
    public boolean containsFullEntryData() {
        return true;
    }

    protected boolean updateEntryPacketTimeToLiveIfNeeded(long expirationTime) {
        long currentTimeToLive;
        long updateTimeToLiveIfNeeded;
        if (!this.getEntryPacket().isExternalizableEntryPacket() && (updateTimeToLiveIfNeeded = this.updateTimeToLiveIfNeeded(expirationTime, currentTimeToLive = this.getEntryPacket().getTTL())) != currentTimeToLive) {
            this.getEntryPacket().setTTL(updateTimeToLiveIfNeeded);
        }
        return true;
    }
}

