/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationInContentContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ITimeToLiveUpdateCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.filters.ReplicationFilterUidDataWrapper;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractReplicationPacketSingleEntryData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationFilterException;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class SingleUidReplicationPacketData
extends AbstractReplicationPacketSingleEntryData {
    private static final long serialVersionUID = 1L;
    private String _uid;
    private OperationID _operationID;
    private boolean _transient;
    protected transient IEntryData _entryData;

    public SingleUidReplicationPacketData() {
    }

    public SingleUidReplicationPacketData(String uid, OperationID operationID, boolean isTransient, boolean fromGateway, IEntryData entryData) {
        super(fromGateway);
        this._uid = uid;
        this._operationID = operationID;
        this._transient = isTransient;
        this._entryData = entryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        try {
            this.executeImpl(context, inReplicationHandler);
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null) {
                this._entryData = contentContext.getMainEntryData();
                contentContext.clear();
            }
        }
    }

    protected abstract void executeImpl(IReplicationInContext var1, IReplicationInFacade var2) throws Exception;

    @Override
    public SingleUidReplicationPacketData clone() {
        return (SingleUidReplicationPacketData)super.clone();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.readExternalImpl(in);
        this._transient = in.readBoolean();
    }

    private final void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        this._uid = IOUtils.readString(in);
        this._operationID = (OperationID)IOUtils.readObject(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.readExternalImpl(in);
        this._transient = in.readBoolean();
        this._entryData = this.deserializeEntryData(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeExternalImpl(out);
        out.writeBoolean(this._transient);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.writeExternalImpl(out);
        out.writeBoolean(this._transient);
        this.serializeEntryData(this._entryData, out);
    }

    private final void writeExternalImpl(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this._uid);
        IOUtils.writeObject(out, this._operationID);
    }

    @Override
    public String getUid() {
        return this._uid;
    }

    @Override
    protected IReplicationFilterEntry toFilterEntry(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = this.getTypeDescriptor(spaceTypeManager);
        ITypeDesc typeDesc = serverTypeDesc == null ? null : serverTypeDesc.getTypeDesc();
        return new ReplicationFilterUidDataWrapper(this, this.getUid(), typeDesc, this.getFilterOldReplicationOpType(), this.getFilterObjectType(), this.getTimeToLiveUpdateCallback());
    }

    protected IServerTypeDesc getTypeDescriptor(SpaceTypeManager spaceTypeManager) {
        IServerTypeDesc serverTypeDesc = null;
        String className = this.getTypeName();
        if (className != null && (serverTypeDesc = spaceTypeManager.getServerTypeDesc(className)) == null) {
            throw new ReplicationFilterException("Could not locate type descriptor for " + className + " while generating replication filter entry for the replication filter");
        }
        return serverTypeDesc;
    }

    @Override
    public int getOrderCode() {
        return this.getUid().hashCode();
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public IEntryData getMainEntryData() {
        return this._entryData;
    }

    @Override
    public IEntryData getSecondaryEntryData() {
        return null;
    }

    protected abstract String getTypeName();

    protected abstract int getFilterObjectType();

    protected abstract ReplicationOperationType getFilterOldReplicationOpType();

    protected ITimeToLiveUpdateCallback getTimeToLiveUpdateCallback() {
        return null;
    }

    @Override
    public OperationID getOperationId() {
        return this._operationID;
    }

    @Override
    public boolean containsFullEntryData() {
        return false;
    }
}

