/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractPrepareDependentTransactionReplicationPacketData;
import com.j_spaces.core.OperationID;
import java.util.logging.Level;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class TransactionCommitReplicationPacketData
extends AbstractPrepareDependentTransactionReplicationPacketData {
    private static final long serialVersionUID = 1L;

    public TransactionCommitReplicationPacketData() {
    }

    public TransactionCommitReplicationPacketData(ServerTransaction transaction, OperationID operationID, boolean fromGateway) {
        super(transaction, operationID, fromGateway);
    }

    @Override
    public ReplicationMultipleOperationType getMultipleOperationType() {
        return ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_COMMIT;
    }

    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        if (!this.attachPrepareContent(dataMediator) && context.getContextLogger() != null && context.getContextLogger().isLoggable(Level.WARNING)) {
            context.getContextLogger().warning("No previous transaction pending state exists for replicated packet data " + this.toString() + ", ignoring operation");
        }
        inReplicationHandler.inTransactionCommit(context, this);
    }

    @Override
    public IExecutableReplicationPacketData<IReplicationTransactionalPacketEntryData> createEmptyMultipleEntryData() {
        return new TransactionCommitReplicationPacketData(this.getTransaction(), this.getOperationID(), this.isFromGateway());
    }

    @Override
    public boolean isPartOfBlobstoreBulk() {
        return false;
    }

    @Override
    protected String getCustomToString() {
        if (this.getMetaData() == null) {
            return super.getCustomToString();
        }
        return super.getCustomToString() + "Participant ID/Count=" + this.getMetaData().getParticipantId() + "/" + this.getMetaData().getTransactionParticipantsCount() + ", ";
    }

    @Override
    public boolean requiresRecoveryFiltering() {
        return true;
    }

    @Override
    public boolean isMultiParticipantData() {
        return false;
    }
}

