/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.j_spaces.core.OperationID;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class TransactionOnePhaseReplicationPacketData
extends AbstractTransactionReplicationPacketData {
    private static final long serialVersionUID = 1L;
    private OperationID _operationID;

    public TransactionOnePhaseReplicationPacketData() {
    }

    public TransactionOnePhaseReplicationPacketData(OperationID operationID, boolean fromGateway) {
        super(fromGateway);
        this._operationID = operationID;
    }

    @Override
    public OperationID getOperationID() {
        return this._operationID;
    }

    @Override
    public ReplicationMultipleOperationType getMultipleOperationType() {
        return ReplicationMultipleOperationType.TRANSACTION_ONE_PHASE;
    }

    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        inReplicationHandler.inTransaction(context, this);
    }

    @Override
    public IExecutableReplicationPacketData<IReplicationTransactionalPacketEntryData> createEmptyMultipleEntryData() {
        TransactionOnePhaseReplicationPacketData data = new TransactionOnePhaseReplicationPacketData(this.getOperationID(), this.isFromGateway());
        data.setMetaData(this.getMetaData());
        return data;
    }

    @Override
    public boolean isPartOfBlobstoreBulk() {
        return false;
    }

    @Override
    public boolean supportsReplicationFilter() {
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeTransactionData(out);
        IOUtils.writeObject(out, this._operationID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.readTransactionData(in);
        this._operationID = (OperationID)IOUtils.readObject(in);
    }

    @Override
    protected String getCustomToString() {
        if (this.getMetaData() == null) {
            return super.getCustomToString();
        }
        return super.getCustomToString() + "OperationID=" + this.getOperationID() + ", Participant ID/Count=" + this.getMetaData().getParticipantId() + "/" + this.getMetaData().getTransactionParticipantsCount() + ", ";
    }

    @Override
    public boolean requiresRecoveryFiltering() {
        return false;
    }

    @Override
    public Object getRecoveryFilteringId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMultiParticipantData() {
        return this.getMetaData() != null && this.getMetaData().getTransactionParticipantsCount() > 1;
    }
}

