/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IExecutableReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class TransactionPrepareReplicationPacketData
extends AbstractTransactionReplicationPacketData {
    private static final long serialVersionUID = 1L;

    public TransactionPrepareReplicationPacketData() {
    }

    public TransactionPrepareReplicationPacketData(ServerTransaction transaction, boolean fromGateway) {
        super(transaction, fromGateway);
    }

    @Override
    public ReplicationMultipleOperationType getMultipleOperationType() {
        return ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_PREPARE;
    }

    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        ServerTransaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("Attempt to set pending content from pending transaction packet which has no server transaction");
        }
        dataMediator.setPendingTransactionData(transaction, this);
        inReplicationHandler.inTransactionPrepare(context, this);
    }

    @Override
    public IExecutableReplicationPacketData<IReplicationTransactionalPacketEntryData> createEmptyMultipleEntryData() {
        return new TransactionPrepareReplicationPacketData(this.getTransaction(), this.isFromGateway());
    }

    @Override
    public boolean isPartOfBlobstoreBulk() {
        return false;
    }

    @Override
    public boolean supportsReplicationFilter() {
        return true;
    }

    @Override
    protected String getCustomToString() {
        if (this.getMetaData() == null) {
            return super.getCustomToString();
        }
        return super.getCustomToString() + "Participant ID=" + this.getMetaData().getParticipantId() + ", ";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeTransaction(out);
        this.writeTransactionData(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.readTransaction(in);
        this.readTransactionData(in);
    }

    @Override
    public boolean requiresRecoveryFiltering() {
        return true;
    }

    @Override
    public boolean isMultiParticipantData() {
        return false;
    }
}

