/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationInContentContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.ItemAddedLaterSerializationMarker;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.view.EntryPacketServerEntryAdapter;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jini.core.transaction.Transaction;

@InternalApi
public class UpdateReplicationPacketData
extends SingleReplicationPacketData
implements IReplicationTransactionalPacketEntryData {
    private static final long serialVersionUID = 1L;
    private boolean _overrideVersion;
    protected short _flags;
    protected transient IEntryData _currentEntryData;
    protected transient IEntryData _previousEntryData;
    private IEntryPacket _previousEntryPacket;
    private transient boolean _serializeFullContent;
    private transient long _expirationTime;

    public UpdateReplicationPacketData() {
    }

    public UpdateReplicationPacketData(IEntryPacket entry, boolean fromGateway, boolean overrideVersion, IEntryData previousEntryData, short flags, long expirationTime, IEntryData currentEntryData) {
        super(entry, fromGateway);
        this._overrideVersion = overrideVersion;
        this._previousEntryData = previousEntryData;
        this._currentEntryData = currentEntryData;
        this._flags = flags;
        this._expirationTime = expirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        try {
            inReplicationHandler.inUpdateEntry(context, this.getEntryPacket(), this.getPreviousEntryPacket(), false, this._overrideVersion, this._flags);
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null && contentContext.getSecondaryEntryData() != null) {
                this._currentEntryData = contentContext.getMainEntryData();
                this._previousEntryData = contentContext.getSecondaryEntryData();
                contentContext.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTransactional(IReplicationInContext context, ITransactionalExecutionCallback transactionExecutionCallback, Transaction transaction, boolean twoPhaseCommit) throws Exception {
        try {
            transactionExecutionCallback.updateEntry(context, transaction, twoPhaseCommit, this.getEntryPacket(), this.getPreviousEntryPacket(), false, this._overrideVersion, this._flags);
        }
        finally {
            ReplicationInContentContext contentContext = context.getContentContext();
            if (contentContext != null && contentContext.getSecondaryEntryData() != null) {
                this._currentEntryData = contentContext.getMainEntryData();
                this._previousEntryData = contentContext.getSecondaryEntryData();
                contentContext.clear();
            }
        }
    }

    @Override
    public void batchExecuteTransactional(IReplicationInBatchContext context, ITransactionalBatchExecutionCallback executionCallback) throws Exception {
        executionCallback.updateEntry(context, this.getEntryPacket(), this.getPreviousEntryPacket(), false, this._flags);
    }

    @Override
    public boolean beforeDelayedReplication() {
        return this.updateEntryPacketTimeToLiveIfNeeded(this._expirationTime);
    }

    @Override
    protected int getFilterObjectType(IServerTypeDesc serverTypeDesc) {
        return 1;
    }

    @Override
    protected ReplicationOperationType getFilterReplicationOpType() {
        return ReplicationOperationType.UPDATE;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.UPDATE;
    }

    public String toString() {
        return "UPDATE: " + this.getEntryPacket();
    }

    @Override
    public UpdateReplicationPacketData clone() {
        UpdateReplicationPacketData clone = (UpdateReplicationPacketData)super.clone();
        clone._overrideVersion = this._overrideVersion;
        clone._flags = this._flags;
        return clone;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().lessThan(PlatformLogicalVersion.v9_1_0)) {
            this.realExternalPre91(in);
        } else {
            this.readExternalPost91(in);
        }
        this._expirationTime = !this.getEntryPacket().isExternalizableEntryPacket() && this.getEntryPacket().getTTL() != Long.MAX_VALUE ? this.getEntryPacket().getTTL() + SystemTime.timeMillis() : Long.MAX_VALUE;
    }

    private void realExternalPre91(ObjectInput in) throws IOException, ClassNotFoundException {
        this._overrideVersion = in.readBoolean();
        if (in.readBoolean()) {
            this._previousEntryData = (IEntryData)IOUtils.readObject(in);
        }
        this._flags = in.readShort();
    }

    private void readExternalPost91(ObjectInput in) throws IOException, ClassNotFoundException {
        this._overrideVersion = in.readBoolean();
        this._flags = in.readShort();
        if (in.readBoolean()) {
            this.deserializePreviousEntryData(in);
        }
    }

    protected void deserializePreviousEntryData(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasPreviousEntryDataBeenSerialzed = in.readBoolean();
        if (!hasPreviousEntryDataBeenSerialzed) {
            return;
        }
        Object[] previousFixedValues = this.deserializePreviousFixedValues(in);
        DynamicPropertiesDeserializationData data = this.deserializePreviousDynamicProperties(in);
        Map<String, Object> previousDynamicProperties = data._serializedPreviousDynamicProperties;
        boolean previousDynamicPropertiesExisted = data._previousDynamicPropertiesExisted;
        this._previousEntryData = this.createPreviousEntryData(previousFixedValues, previousDynamicProperties, previousDynamicPropertiesExisted);
    }

    private Object[] deserializePreviousFixedValues(ObjectInput in) throws IOException, ClassNotFoundException {
        Object[] serializedPreviousFixedProperties = null;
        if (in.readBoolean()) {
            int arrayLength = in.readInt();
            serializedPreviousFixedProperties = new Object[arrayLength];
            for (int i = 0; i < serializedPreviousFixedProperties.length; ++i) {
                boolean useSerializedValue = in.readBoolean();
                serializedPreviousFixedProperties[i] = useSerializedValue ? IOUtils.readObject(in) : this.getEntryPacket().getFieldValues()[i];
            }
        }
        return serializedPreviousFixedProperties;
    }

    private DynamicPropertiesDeserializationData deserializePreviousDynamicProperties(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap<String, Object> serializedPreviousDynamicProperties = null;
        boolean previousDynamicPropertiesExisted = false;
        if (in.readBoolean()) {
            previousDynamicPropertiesExisted = true;
            int size = in.readInt();
            serializedPreviousDynamicProperties = new HashMap<String, Object>();
            for (int i = 0; i < size; ++i) {
                String key = IOUtils.readString(in);
                Object value = IOUtils.readObject(in);
                if (value != null) {
                    serializedPreviousDynamicProperties.put(key, value);
                    continue;
                }
                boolean itemAddedLater = in.readBoolean();
                if (itemAddedLater) {
                    serializedPreviousDynamicProperties.put(key, ItemAddedLaterSerializationMarker.INSTANCE);
                    continue;
                }
                serializedPreviousDynamicProperties.put(key, value);
            }
            if (this.getEntryPacket().getDynamicProperties() != null) {
                for (Map.Entry<String, Object> dynamicProperty : this.getEntryPacket().getDynamicProperties().entrySet()) {
                    if (serializedPreviousDynamicProperties.containsKey(dynamicProperty.getKey())) continue;
                    serializedPreviousDynamicProperties.put(dynamicProperty.getKey(), dynamicProperty.getValue());
                }
                Iterator previousIterator = serializedPreviousDynamicProperties.entrySet().iterator();
                while (previousIterator.hasNext()) {
                    Map.Entry previousDynamicProperty = previousIterator.next();
                    if (previousDynamicProperty.getValue() != ItemAddedLaterSerializationMarker.INSTANCE) continue;
                    previousIterator.remove();
                }
            }
        } else {
            previousDynamicPropertiesExisted = in.readBoolean();
        }
        return new DynamicPropertiesDeserializationData(previousDynamicPropertiesExisted, serializedPreviousDynamicProperties);
    }

    private EntryPacketServerEntryAdapter createPreviousEntryData(Object[] previousFixedValues, Map<String, Object> previousDynamicProperties, boolean previousDynamicPropertiesExisted) {
        this._previousEntryPacket = this.getEntryPacket().clone();
        if (previousFixedValues != null) {
            this._previousEntryPacket.setFieldsValues(previousFixedValues);
        }
        if (previousDynamicProperties != null) {
            this._previousEntryPacket.setDynamicProperties(previousDynamicProperties);
        } else if (!previousDynamicPropertiesExisted) {
            this._previousEntryPacket.setDynamicProperties(null);
        }
        if (this._previousEntryPacket.hasPreviousVersion()) {
            this._previousEntryPacket.setVersion(this._previousEntryPacket.getPreviousVersion());
        } else {
            this._previousEntryPacket.setVersion(this._previousEntryPacket.getVersion() - 1);
        }
        return new EntryPacketServerEntryAdapter(this._previousEntryPacket);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (LRMIInvocationContext.getEndpointLogicalVersion().lessThan(PlatformLogicalVersion.v9_1_0)) {
            this.writeExternalPre91(out);
        } else {
            this.writeExternalPost91(out);
        }
    }

    private void writeExternalPre91(ObjectOutput out) throws IOException {
        out.writeBoolean(this._overrideVersion);
        out.writeBoolean(this._serializeFullContent);
        if (this._serializeFullContent) {
            this.writePreviousEntryData(out);
        }
        out.writeShort(this._flags);
    }

    protected void writePreviousEntryData(ObjectOutput out) throws IOException {
        this.serializeEntryData(this._previousEntryData, out);
    }

    protected void readPreviousEntryData(ObjectInput in) throws IOException, ClassNotFoundException {
        this._previousEntryData = this.deserializeEntryData(in);
    }

    private void writeExternalPost91(ObjectOutput out) throws IOException {
        out.writeBoolean(this._overrideVersion);
        out.writeShort(this._flags);
        out.writeBoolean(this._serializeFullContent);
        if (this._serializeFullContent) {
            this.serializePreviousEntryData(out);
        }
    }

    protected void serializePreviousEntryData(ObjectOutput out) throws IOException {
        if (this._previousEntryData != null) {
            out.writeBoolean(true);
            this.serializePreviousFixedValues(out);
            this.serializePreviousDynamicProperties(out);
        } else {
            out.writeBoolean(false);
        }
    }

    private void serializePreviousFixedValues(ObjectOutput out) throws IOException {
        Object[] serializedPreviousFixedProperties = null;
        Object[] fixedProperties = this.getEntryPacket().getFieldValues();
        Object[] previousFixedProperties = this._previousEntryData.getFixedPropertiesValues();
        for (int i = 0; i < fixedProperties.length; ++i) {
            if (fixedProperties[i] != null) {
                if (previousFixedProperties[i] == null) {
                    serializedPreviousFixedProperties = UpdateReplicationPacketData.instantiateArrayIfNeeded(serializedPreviousFixedProperties, fixedProperties.length);
                    serializedPreviousFixedProperties[i] = ItemAddedLaterSerializationMarker.INSTANCE;
                    continue;
                }
                if (previousFixedProperties[i].equals(fixedProperties[i])) continue;
                serializedPreviousFixedProperties = UpdateReplicationPacketData.instantiateArrayIfNeeded(serializedPreviousFixedProperties, fixedProperties.length);
                serializedPreviousFixedProperties[i] = previousFixedProperties[i];
                continue;
            }
            if (previousFixedProperties[i] == null) continue;
            serializedPreviousFixedProperties = UpdateReplicationPacketData.instantiateArrayIfNeeded(serializedPreviousFixedProperties, fixedProperties.length);
            serializedPreviousFixedProperties[i] = previousFixedProperties[i];
        }
        boolean serialize = serializedPreviousFixedProperties != null;
        out.writeBoolean(serialize);
        if (serialize) {
            out.writeInt(serializedPreviousFixedProperties.length);
            for (int i = 0; i < serializedPreviousFixedProperties.length; ++i) {
                if (serializedPreviousFixedProperties[i] == ItemAddedLaterSerializationMarker.INSTANCE) {
                    out.writeBoolean(true);
                    IOUtils.writeObject(out, null);
                    continue;
                }
                if (serializedPreviousFixedProperties[i] != null) {
                    out.writeBoolean(true);
                    IOUtils.writeObject(out, serializedPreviousFixedProperties[i]);
                    continue;
                }
                out.writeBoolean(false);
            }
        }
    }

    private static Object[] instantiateArrayIfNeeded(Object[] array, int length) {
        if (array == null) {
            return new Object[length];
        }
        return array;
    }

    private void serializePreviousDynamicProperties(ObjectOutput out) throws IOException {
        Map<String, Object> serializedPreviousDynamicProperties = null;
        if (this.getEntryPacket().getDynamicProperties() != null && this._previousEntryData.getDynamicProperties() != null) {
            for (Map.Entry<String, Object> dynamicProperty : this.getEntryPacket().getDynamicProperties().entrySet()) {
                boolean previousValueExists = this._previousEntryData.getDynamicProperties().containsKey(dynamicProperty.getKey());
                Object previousValue = this._previousEntryData.getDynamicProperties().get(dynamicProperty.getKey());
                if (!previousValueExists) {
                    serializedPreviousDynamicProperties = UpdateReplicationPacketData.instantiateMapIfNeeded(serializedPreviousDynamicProperties);
                    serializedPreviousDynamicProperties.put(dynamicProperty.getKey(), ItemAddedLaterSerializationMarker.INSTANCE);
                    continue;
                }
                if (previousValue != null && previousValue.equals(dynamicProperty.getValue())) continue;
                serializedPreviousDynamicProperties = UpdateReplicationPacketData.instantiateMapIfNeeded(serializedPreviousDynamicProperties);
                serializedPreviousDynamicProperties.put(dynamicProperty.getKey(), previousValue);
            }
            for (Map.Entry<String, Object> previousDynamicProperty : this._previousEntryData.getDynamicProperties().entrySet()) {
                if (this.getEntryPacket().getDynamicProperties().containsKey(previousDynamicProperty.getKey())) continue;
                serializedPreviousDynamicProperties = UpdateReplicationPacketData.instantiateMapIfNeeded(serializedPreviousDynamicProperties);
                serializedPreviousDynamicProperties.put(previousDynamicProperty.getKey(), previousDynamicProperty.getValue());
            }
        } else if (this._previousEntryData.getDynamicProperties() != null) {
            serializedPreviousDynamicProperties = this._previousEntryData.getDynamicProperties();
        }
        boolean serialize = serializedPreviousDynamicProperties != null;
        out.writeBoolean(serialize);
        if (serialize) {
            out.writeInt(serializedPreviousDynamicProperties.size());
            for (Map.Entry<String, Object> previousDynamicProperty : serializedPreviousDynamicProperties.entrySet()) {
                if (previousDynamicProperty.getValue() == ItemAddedLaterSerializationMarker.INSTANCE) {
                    IOUtils.writeString(out, previousDynamicProperty.getKey());
                    IOUtils.writeObject(out, null);
                    out.writeBoolean(true);
                    continue;
                }
                if (previousDynamicProperty.getValue() == null) {
                    IOUtils.writeString(out, previousDynamicProperty.getKey());
                    IOUtils.writeObject(out, null);
                    out.writeBoolean(false);
                    continue;
                }
                IOUtils.writeString(out, previousDynamicProperty.getKey());
                IOUtils.writeObject(out, previousDynamicProperty.getValue());
            }
        } else {
            out.writeBoolean(this._previousEntryData.getDynamicProperties() != null);
        }
    }

    private static Map<String, Object> instantiateMapIfNeeded(Map<String, Object> map) {
        if (map == null) {
            return new HashMap<String, Object>();
        }
        return map;
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._overrideVersion = in.readBoolean();
        this.deserializePreviousEntryData(in);
        this._flags = in.readShort();
        this._expirationTime = in.readLong();
        this.restoreCurrentEntryData();
    }

    protected void restoreCurrentEntryData() {
        this._currentEntryData = new EntryPacketServerEntryAdapter(this.getEntryPacket());
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        out.writeBoolean(this._overrideVersion);
        this.serializePreviousEntryData(out);
        out.writeShort(this._flags);
        out.writeLong(this._expirationTime);
    }

    @Override
    public IEntryData getMainEntryData() {
        return this._currentEntryData;
    }

    @Override
    public IEntryData getSecondaryEntryData() {
        return this._previousEntryData;
    }

    public IEntryPacket getPreviousEntryPacket() {
        return this._previousEntryPacket;
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return true;
    }

    public void serializeFullContent() {
        this._serializeFullContent = true;
    }

    public boolean isSerializeFullContent() {
        return this._serializeFullContent;
    }

    public boolean isOverrideVersion() {
        return this._overrideVersion;
    }

    public short getFlags() {
        return this._flags;
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }

    private static class DynamicPropertiesDeserializationData {
        boolean _previousDynamicPropertiesExisted;
        Map<String, Object> _serializedPreviousDynamicProperties;

        public DynamicPropertiesDeserializationData(boolean previousDynamicPropertiesExisted, Map<String, Object> serializedPreviousDynamicProperties) {
            this._previousDynamicPropertiesExisted = previousDynamicPropertiesExisted;
            this._serializedPreviousDynamicProperties = serializedPreviousDynamicProperties;
        }
    }
}

