/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.packets.data.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalExecutionCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.SingleReplicationPacketData;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cluster.ReplicationOperationType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.transaction.Transaction;

@InternalApi
public class WriteReplicationPacketData
extends SingleReplicationPacketData
implements IReplicationTransactionalPacketEntryData {
    private static final long serialVersionUID = 1L;
    private transient long _expirationTime;

    public WriteReplicationPacketData() {
    }

    @Override
    public WriteReplicationPacketData clone() {
        return (WriteReplicationPacketData)super.clone();
    }

    public WriteReplicationPacketData(IEntryPacket entry, boolean fromGateway, long expirationTime) {
        super(entry, fromGateway);
        this._expirationTime = expirationTime;
    }

    @Override
    public void execute(IReplicationInContext context, IReplicationInFacade inReplicationHandler, ReplicationPacketDataMediator dataMediator) throws Exception {
        inReplicationHandler.inWriteEntry(context, this.getEntryPacket());
    }

    @Override
    public void executeTransactional(IReplicationInContext context, ITransactionalExecutionCallback transactionExecutionCallback, Transaction transaction, boolean twoPhaseCommit) throws Exception {
        transactionExecutionCallback.writeEntry(context, transaction, twoPhaseCommit, this.getEntryPacket());
    }

    @Override
    public void batchExecuteTransactional(IReplicationInBatchContext context, ITransactionalBatchExecutionCallback executionCallback) throws Exception {
        executionCallback.writeEntry(context, this.getEntryPacket());
    }

    @Override
    public boolean beforeDelayedReplication() {
        return this.updateEntryPacketTimeToLiveIfNeeded(this._expirationTime);
    }

    @Override
    protected int getFilterObjectType(IServerTypeDesc serverTypeDesc) {
        return 1;
    }

    @Override
    protected ReplicationOperationType getFilterReplicationOpType() {
        return ReplicationOperationType.WRITE;
    }

    @Override
    public ReplicationSingleOperationType getOperationType() {
        return ReplicationSingleOperationType.WRITE;
    }

    public String toString() {
        return "WRITE: " + this.getEntryPacket();
    }

    @Override
    public boolean filterIfNotPresentInReplicaState() {
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._expirationTime = !this.getEntryPacket().isExternalizableEntryPacket() && this.getEntryPacket().getTTL() != Long.MAX_VALUE ? this.getEntryPacket().getTTL() + SystemTime.timeMillis() : Long.MAX_VALUE;
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        out.writeLong(this._expirationTime);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._expirationTime = in.readLong();
    }

    public long getExpirationTime() {
        return this._expirationTime;
    }
}

