/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog;

import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.j_spaces.core.exception.SpaceUnavailableException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSingleFileTargetProcessLog {
    protected final Logger _specificLogger;
    protected final IReplicationPacketDataConsumer _dataConsumer;
    private final IReplicationProcessLogExceptionHandler _exceptionHandler;
    private final IReplicationInFacade _replicationInFacade;
    private final String _name;
    private final String _groupName;
    private final ReplicationInContext _replicationInContext;
    private final IReplicationGroupHistory _groupHistory;
    private final String _sourceLookupName;

    public AbstractSingleFileTargetProcessLog(IReplicationPacketDataConsumer dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        this._dataConsumer = dataConsumer;
        this._exceptionHandler = exceptionHandler;
        this._replicationInFacade = replicationInFacade;
        this._name = name;
        this._groupName = groupName;
        this._sourceLookupName = sourceLookupName;
        this._groupHistory = groupHistory;
        this._specificLogger = ReplicationLogUtils.createChannelSpecificLogger(this._sourceLookupName, this._name, this._groupName);
        this._replicationInContext = this.createReplicationInContext();
    }

    public ReplicationInContext createReplicationInContext() {
        return new ReplicationInContext(this._sourceLookupName, this._groupName, this._specificLogger, this.contentRequiredWhileProcessing(), false);
    }

    protected abstract boolean contentRequiredWhileProcessing();

    public <T extends IReplicationPacketData<?>> IReplicationPacketDataConsumer<T> getDataConsumer() {
        return this._dataConsumer;
    }

    public ReplicationInContext getReplicationInContext() {
        return this._replicationInContext;
    }

    public IReplicationGroupHistory getGroupHistory() {
        return this._groupHistory;
    }

    protected String getSourceLookupName() {
        return this._sourceLookupName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public IReplicationProcessLogExceptionHandler getExceptionHandler() {
        return this._exceptionHandler;
    }

    public IReplicationInFacade getReplicationInFacade() {
        return this._replicationInFacade;
    }

    public String toLogMessage() {
        return this.dumpState();
    }

    protected Level getLogLevel(Throwable error) {
        if (error instanceof SpaceUnavailableException) {
            return Level.FINER;
        }
        return Level.FINER;
    }

    public abstract String dumpState();

    public static void throwIfRepetitiveError(IDataConsumeResult prevResult, IDataConsumeResult consumeResult) throws Exception {
        if (consumeResult.toException() instanceof BlobStoreException) {
            throw consumeResult.toException();
        }
        if (prevResult == null) {
            return;
        }
        if (consumeResult.sameFailure(prevResult)) {
            throw consumeResult.toException();
        }
    }
}

