/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.HandleDataConsumeErrorPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationConnection;

@InternalApi
public class DefaultProcessLogExceptionHandler
implements IReplicationProcessLogExceptionHandler {
    private final IReplicationConnection _connectionToSource;
    private final String _groupName;

    public DefaultProcessLogExceptionHandler(IReplicationConnection sourceConnection, String sourceMemberLookupName, String groupName) {
        this._groupName = groupName;
        this._connectionToSource = sourceConnection;
    }

    @Override
    public void close() {
        this._connectionToSource.close();
    }

    @Override
    public IDataConsumeFix handleException(IDataConsumeResult errorResult, IReplicationOrderedPacket packet) throws Exception {
        return this._connectionToSource.dispatch(new HandleDataConsumeErrorPacket(errorResult, this._groupName, packet != null ? packet.getKey() : -1L));
    }
}

