/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IReplicationReliableAsyncMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationBatchConsumeAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.DistributedTransactionProcessingConfiguration;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceSingleFileProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceSingleFileProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.sync.IReplicationSyncTargetProcessLog;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReliableAsyncAdaptiveProcessLogBuilder
implements IReplicationProcessLogBuilder {
    private static final String MULTI_SOURCE_MODE = "multi-source";
    private final GlobalOrderProcessLogBuilder _globalOrderBuilder;
    private final MultiBucketSingleFileProcessLogBuilder _multiBucketSingleFileBuilder;
    private final IReplicationPacketDataConsumer<?> _dataConsumer;
    private final MultiSourceSingleFileProcessLogBuilder _multiSourceSingleFileBuilder;
    private final DistributedTransactionProcessingConfiguration _distributedTransactionProcessingConfiguration;

    public ReliableAsyncAdaptiveProcessLogBuilder(IReplicationPacketDataBatchConsumer<?> dataConsumer, DistributedTransactionProcessingConfiguration distributedTransactionProcessingConfiguration) {
        this._dataConsumer = dataConsumer;
        this._globalOrderBuilder = new GlobalOrderProcessLogBuilder(dataConsumer);
        this._multiBucketSingleFileBuilder = new MultiBucketSingleFileProcessLogBuilder(dataConsumer);
        this._multiSourceSingleFileBuilder = new MultiSourceSingleFileProcessLogBuilder(dataConsumer);
        this._distributedTransactionProcessingConfiguration = distributedTransactionProcessingConfiguration;
    }

    @Override
    public IReplicationSyncTargetProcessLog createSyncProcessLog(TargetGroupConfig groupConfig, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReplicationAsyncTargetProcessLog createAsyncProcessLog(TargetGroupConfig groupConfig, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReplicationBatchConsumeAsyncTargetProcessLog createBatchConsumeAsyncProcessLog(TargetGroupConfig groupConfig, IBacklogHandshakeRequest handshakeRequest, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        if (handshakeRequest instanceof MultiBucketSingleFileHandshakeRequest) {
            MultiBucketSingleFileProcessLogConfig processLogConfig = new MultiBucketSingleFileProcessLogConfig();
            processLogConfig.setBucketsCount((short)((MultiBucketSingleFileHandshakeRequest)handshakeRequest).getBucketsConfirmedKeys().length);
            TargetGroupConfig newGroupConfig = new TargetGroupConfig(groupConfig.getName(), processLogConfig, groupConfig.getGroupChannelType(), groupConfig.getMembersLookupNames());
            newGroupConfig.setChannelCloseTimeout(groupConfig.getChannelCloseTimeout());
            newGroupConfig.setUnbounded(groupConfig.isUnbounded());
            return this._multiBucketSingleFileBuilder.createBatchConsumeAsyncProcessLog(newGroupConfig, handshakeRequest, replicationInFacade, exceptionHandler, myLookupName, groupName, sourceLookupName, groupHistory);
        }
        return this._globalOrderBuilder.createBatchConsumeAsyncProcessLog(groupConfig, handshakeRequest, replicationInFacade, exceptionHandler, myLookupName, groupName, sourceLookupName, groupHistory);
    }

    @Override
    public IReplicationSyncTargetProcessLog createReliableAsyncKeeperProcessLog(TargetGroupConfig groupConfig, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory, IReplicationReliableAsyncMediator mediator, IReplicationSyncTargetProcessLog synchronizingProcessLog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReplicationReliableAsyncTargetProcessLog createReliableAsyncProcessLog(TargetGroupConfig groupConfig, IBacklogHandshakeRequest handshakeRequest, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationReliableAsyncTargetProcessLog synchronizingProcessLog, IReplicationGroupHistory groupHistory, Logger specificLogger) {
        if (handshakeRequest instanceof MultiBucketSingleFileHandshakeRequest) {
            this.verifyReplicationModeOnDistributedTransactionProcessingConfiguration(specificLogger);
            MultiBucketSingleFileProcessLogConfig processLogConfig = new MultiBucketSingleFileProcessLogConfig();
            processLogConfig.setBucketsCount((short)((MultiBucketSingleFileHandshakeRequest)handshakeRequest).getBucketsConfirmedKeys().length);
            TargetGroupConfig newGroupConfig = new TargetGroupConfig(groupConfig.getName(), processLogConfig, groupConfig.getGroupChannelType(), groupConfig.getMembersLookupNames());
            newGroupConfig.setChannelCloseTimeout(groupConfig.getChannelCloseTimeout());
            newGroupConfig.setUnbounded(groupConfig.isUnbounded());
            return this._multiBucketSingleFileBuilder.createReliableAsyncProcessLog(newGroupConfig, handshakeRequest, replicationInFacade, exceptionHandler, myLookupName, groupName, sourceLookupName, synchronizingProcessLog, groupHistory, specificLogger);
        }
        if (handshakeRequest instanceof MultiSourceSingleFileBacklogHandshakeRequest) {
            MultiSourceSingleFileProcessLogConfig processLogConfig = new MultiSourceSingleFileProcessLogConfig();
            processLogConfig.setConsumeTimeout(this._distributedTransactionProcessingConfiguration.getTimeoutBeforePartialCommit());
            processLogConfig.setPendingPacketPacketsIntervalBeforeConsumption(this._distributedTransactionProcessingConfiguration.getWaitForOperationsBeforePartialCommit());
            processLogConfig.setMonitorPendingOperationsMemory(this._distributedTransactionProcessingConfiguration.isMonitorPendingOperationsMemory());
            TargetGroupConfig newGroupConfig = new TargetGroupConfig(groupConfig.getName(), processLogConfig, groupConfig.getGroupChannelType(), groupConfig.getMembersLookupNames());
            return this._multiSourceSingleFileBuilder.createReliableAsyncProcessLog(newGroupConfig, handshakeRequest, replicationInFacade, exceptionHandler, myLookupName, groupName, sourceLookupName, synchronizingProcessLog, groupHistory, specificLogger);
        }
        this.verifyReplicationModeOnDistributedTransactionProcessingConfiguration(specificLogger);
        return this._globalOrderBuilder.createReliableAsyncProcessLog(groupConfig, handshakeRequest, replicationInFacade, exceptionHandler, myLookupName, groupName, sourceLookupName, synchronizingProcessLog, groupHistory, specificLogger);
    }

    private void verifyReplicationModeOnDistributedTransactionProcessingConfiguration(Logger specificLogger) {
        if (this._distributedTransactionProcessingConfiguration.isOverriden() && specificLogger.isLoggable(Level.WARNING)) {
            specificLogger.log(Level.WARNING, "Distributed transaction processing configuration has been set but replication mode was not set to 'multi-source' - configuration will be ignored");
        }
    }

    public String toString() {
        return "ReliableAsyncAdaptiveProcessLogBuilder [_dataConsumer=" + this._dataConsumer + "]";
    }
}

