/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.globalorder;

import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDeletedBacklogPacket;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.AbstractSingleFileTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogState;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.j_spaces.core.exception.ClosedResourceException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public abstract class AbstractGlobalOrderTargetProcessLog
extends AbstractSingleFileTargetProcessLog
implements IReplicationTargetProcessLog {
    protected final Object _lifeCycleLock = new Object();
    protected final Lock _lock = new ReentrantLock();
    protected long _lastProcessedKey;
    private ProcessLogState _state = ProcessLogState.OPEN;
    private boolean _firstHandshakeForTarget;

    public AbstractGlobalOrderTargetProcessLog(IReplicationPacketDataConsumer dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, long lastProcessedKey, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory) {
        super(dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, groupHistory);
        this._lastProcessedKey = lastProcessedKey;
        this._firstHandshakeForTarget = firstHandshakeForTarget;
    }

    public long getLastProcessedKey() {
        this._lock.lock();
        try {
            long l = this._lastProcessedKey;
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean isFirstHandshakeForTarget() {
        this._lock.lock();
        try {
            boolean bl = this._firstHandshakeForTarget;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public GlobalOrderProcessLogHandshakeResponse performHandshake(String memberName, IBacklogHandshakeRequest handshakeRequest) throws IncomingReplicationOutOfSyncException {
        Object object = this._lifeCycleLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedResourceException("Process log is closed");
            }
            GlobalOrderBacklogHandshakeRequest typedHandshakeRequest = (GlobalOrderBacklogHandshakeRequest)handshakeRequest;
            if (this._firstHandshakeForTarget) {
                this._firstHandshakeForTarget = false;
                this._lastProcessedKey = typedHandshakeRequest.getLastConfirmedKey();
                return new GlobalOrderProcessLogHandshakeResponse(this._lastProcessedKey);
            }
            if (handshakeRequest.isFirstHandshake() && this.canResetState()) {
                this._lastProcessedKey = typedHandshakeRequest.getLastConfirmedKey();
                return new GlobalOrderProcessLogHandshakeResponse(this._lastProcessedKey);
            }
            if (typedHandshakeRequest.getLastConfirmedKey() <= this._lastProcessedKey) {
                return new GlobalOrderProcessLogHandshakeResponse(this._lastProcessedKey);
            }
            throw new IncomingReplicationOutOfSyncException("Replication out of sync, received last confirmed key " + typedHandshakeRequest.getLastConfirmedKey() + " while last processed key is " + this._lastProcessedKey);
        }
    }

    protected boolean canResetState() {
        return true;
    }

    protected void throwClosedException() {
        throw new ClosedResourceException("Process log is closed");
    }

    protected void filterDuplicate(List<IReplicationOrderedPacket> packets) {
        IReplicationOrderedPacket packet;
        Iterator<IReplicationOrderedPacket> iterator = packets.iterator();
        while (iterator.hasNext() && this.filterDuplicate(packet = iterator.next())) {
            iterator.remove();
        }
    }

    protected boolean filterDuplicate(IReplicationOrderedPacket packet) {
        return packet.getEndKey() <= this._lastProcessedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(long time, TimeUnit unit) throws InterruptedException {
        Object object = this._lifeCycleLock;
        synchronized (object) {
            this._state = ProcessLogState.CLOSING;
        }
        if (!this._lock.tryLock(time, unit)) {
            object = this._lifeCycleLock;
            synchronized (object) {
                this._state = ProcessLogState.CLOSED;
            }
            return false;
        }
        try {
            this._state = ProcessLogState.CLOSED;
            this.onClose();
            boolean bl = true;
            return bl;
        }
        finally {
            this.getExceptionHandler().close();
            this._lock.unlock();
        }
    }

    protected boolean isOpen() {
        return this._state == ProcessLogState.OPEN;
    }

    protected boolean isClosed() {
        return this._state == ProcessLogState.CLOSED;
    }

    protected abstract void onClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessLogHandshakeResponse resync(IBacklogHandshakeRequest handshakeRequest) {
        this._lock.lock();
        try {
            if (!this.isOpen()) {
                throw new ClosedResourceException("Process log is closed");
            }
            GlobalOrderBacklogHandshakeRequest typedHandshakeRequest = (GlobalOrderBacklogHandshakeRequest)handshakeRequest;
            this._firstHandshakeForTarget = false;
            this._lastProcessedKey = typedHandshakeRequest.getLastConfirmedKey();
            GlobalOrderProcessLogHandshakeResponse globalOrderProcessLogHandshakeResponse = new GlobalOrderProcessLogHandshakeResponse(this._lastProcessedKey);
            return globalOrderProcessLogHandshakeResponse;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void processHandshakeIteration(String sourceMemberName, IHandshakeIteration handshakeIteration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toWireForm(IProcessResult processResult) {
        if (processResult == GlobalOrderProcessResult.OK) {
            return null;
        }
        return processResult;
    }

    protected void logDeletion(GlobalOrderDeletedBacklogPacket deletedBacklogPacket) {
        String deletionMessage = "packets [" + deletedBacklogPacket.getKey() + "-" + deletedBacklogPacket.getEndKey() + "] are lost due to backlog deletion at the source";
        this.getGroupHistory().logEvent(this.getSourceLookupName(), deletionMessage);
        if (this._specificLogger.isLoggable(Level.WARNING)) {
            this._specificLogger.warning(deletionMessage);
        }
    }

    @Override
    public String dumpState() {
        return "State [" + (Object)((Object)this._state) + "] had any handshake [" + !this._firstHandshakeForTarget + "] last process key [" + this._lastProcessedKey + "] processing queue state " + this.dumpStateExtra();
    }

    protected String dumpStateExtra() {
        return "";
    }

    @Override
    public IProcessResult processIdleStateData(String string, IIdleStateData idleStateData, IReplicationInFilterCallback inFilterCallback) {
        throw new UnsupportedOperationException();
    }
}

