/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDeletedBacklogPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationBatchConsumeAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.AbstractGlobalOrderTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.IBatchExecutedCallback;
import com.j_spaces.core.exception.ClosedResourceException;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.List;
import java.util.logging.Level;

@InternalApi
public class GlobalOrderBatchConsumeTargetProcessLog
extends AbstractGlobalOrderTargetProcessLog
implements IReplicationBatchConsumeAsyncTargetProcessLog,
IBatchExecutedCallback {
    private final IReplicationPacketDataBatchConsumer<?> _batchDataConsumer;

    protected GlobalOrderBatchConsumeTargetProcessLog(IReplicationPacketDataBatchConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, long lastProcessedKey, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory) {
        super(dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, lastProcessedKey, firstHandshakeForTarget, groupHistory);
        this._batchDataConsumer = dataConsumer;
    }

    public GlobalOrderBatchConsumeTargetProcessLog(IReplicationPacketDataBatchConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        this(dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, -1L, true, groupHistory);
    }

    @Override
    protected boolean contentRequiredWhileProcessing() {
        return false;
    }

    @Override
    protected void onClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalOrderProcessResult processBatch(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) {
        if (!this.isOpen()) {
            this.throwClosedException();
        }
        this._lock.lock();
        try {
            if (this.isClosed()) {
                this.throwClosedException();
            }
            this.filterDuplicate(packets);
            if (packets.isEmpty()) {
                GlobalOrderProcessResult globalOrderProcessResult = GlobalOrderProcessResult.OK;
                return globalOrderProcessResult;
            }
            long firstKeyInBatch = packets.get(0).getKey();
            if (this._lastProcessedKey + 1L < firstKeyInBatch) {
                GlobalOrderProcessResult globalOrderProcessResult = new GlobalOrderProcessResult(new ReplicationInternalSpaceException("Incompatible keys, last processed is " + this._lastProcessedKey + " while first packets received is " + firstKeyInBatch), this._lastProcessedKey);
                return globalOrderProcessResult;
            }
            GlobalOrderProcessResult globalOrderProcessResult = this.processPackets(sourceLookupName, packets, inFilterCallback);
            return globalOrderProcessResult;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public IProcessResult process(String sourceLookupName, IReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalOrderProcessResult processPackets(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) throws Exception {
        GlobalOrderReplicationInBatchContext context = new GlobalOrderReplicationInBatchContext(this, this._specificLogger, packets.size(), sourceLookupName, this.getGroupName());
        int lastDataPacketIndex = this.locateLastDataPacketIndex(packets);
        int packetIndex = 0;
        block3: for (IReplicationOrderedPacket packet : packets) {
            if (packetIndex++ > lastDataPacketIndex) break;
            if (!this.preprocess(packet)) continue;
            context.setContextPacket(packet);
            try {
                IReplicationPacketData<?> data = packet.getData();
                context.setCurrentKey(packet.getKey());
                IDataConsumeResult prevResult = null;
                while (true) {
                    if (this.isClosed()) {
                        throw new ClosedResourceException("Process log is closed");
                    }
                    context.snapshot();
                    IDataConsumeResult consumeResult = this.getDataConsumer().consume(context, data, this.getReplicationInFacade(), inFilterCallback);
                    if (!consumeResult.isFailed()) continue block3;
                    GlobalOrderBatchConsumeTargetProcessLog.throwIfRepetitiveError(prevResult, consumeResult);
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.log(Level.FINER, "Encountered error while consuming packet [" + packet + "], trying to resolve issue", consumeResult.toException());
                    }
                    IDataConsumeFix fix = this.getExceptionHandler().handleException(consumeResult, null);
                    data = this.getDataConsumer().applyFix(context, data, fix);
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.log(Level.FINER, "Fix applied - retrying the operation [" + fix + "]");
                    }
                    context.rollback();
                    prevResult = consumeResult;
                }
            }
            finally {
                context.setContextPacket(null);
            }
        }
        this.consumePendingPacketsInBatch(context);
        int batchSize = packets.size();
        if (batchSize > 0 && lastDataPacketIndex < batchSize - 1) {
            IReplicationOrderedPacket packet;
            packet = (GlobalOrderDiscardedReplicationPacket)packets.get(batchSize - 1);
            this._lastProcessedKey = ((GlobalOrderDiscardedReplicationPacket)packet).getEndKey();
        }
        return GlobalOrderProcessResult.OK;
    }

    private void consumePendingPacketsInBatch(GlobalOrderReplicationInBatchContext context) throws Exception {
        if (this.isClosed()) {
            throw new ClosedResourceException("Process log is closed");
        }
        IDataConsumeResult result = this._batchDataConsumer.consumePendingPackets(context, this.getReplicationInFacade());
        if (result.isFailed()) {
            throw result.toException();
        }
    }

    private int locateLastDataPacketIndex(List<IReplicationOrderedPacket> packets) {
        int lastDataPacketIndex = -1;
        int index = -1;
        for (IReplicationOrderedPacket packet : packets) {
            ++index;
            if (!packet.isDataPacket()) continue;
            lastDataPacketIndex = index;
        }
        return lastDataPacketIndex;
    }

    private boolean preprocess(IReplicationOrderedPacket packet) {
        if (packet.isDataPacket()) {
            return true;
        }
        if (packet instanceof GlobalOrderDiscardedReplicationPacket) {
            return false;
        }
        if (packet instanceof GlobalOrderDeletedBacklogPacket) {
            this.logDeletion((GlobalOrderDeletedBacklogPacket)packet);
            return false;
        }
        return true;
    }

    @Override
    public void batchConsumed(long lastProcessKeyInBatch) {
        this._lastProcessedKey = lastProcessKeyInBatch;
    }
}

