/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class GlobalOrderProcessResult
implements IProcessResult {
    private static final long serialVersionUID = 1L;
    public static final GlobalOrderProcessResult OK = new GlobalOrderProcessResult(true);
    private boolean _processed;
    private Throwable _error;
    private long _lastProcessedKey;

    public GlobalOrderProcessResult() {
    }

    public GlobalOrderProcessResult(boolean processed) {
        this._processed = processed;
    }

    public GlobalOrderProcessResult(Throwable error, long lastProcessedKey) {
        this._processed = false;
        this._error = error;
        this._lastProcessedKey = lastProcessedKey;
    }

    public boolean isProcessed() {
        return this._processed;
    }

    public long getLastProcessedKey() {
        return this._lastProcessedKey;
    }

    public Throwable getError() {
        return this._error;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._processed = in.readBoolean();
        if (!this._processed) {
            this._error = (Throwable)IOUtils.readObject(in);
            this._lastProcessedKey = in.readLong();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._processed);
        if (!this._processed) {
            IOUtils.writeObject(out, this._error);
            out.writeLong(this._lastProcessedKey);
        }
    }

    public String toString() {
        return "GlobalOrderProcessResult [processed=" + this._processed + ", lastProcessedKey=" + this._lastProcessedKey + ", error=" + this._error + "]";
    }
}

