/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.processlog.sync.oneway.IProcessStatus;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class GlobalOrderProcessStatus
implements IProcessStatus {
    private static final long serialVersionUID = 1L;
    private long _lastProcessedKey;
    private Throwable _error;

    public GlobalOrderProcessStatus() {
    }

    public GlobalOrderProcessStatus(long lastProcessedKey, Throwable error) {
        this._lastProcessedKey = lastProcessedKey;
        this._error = error;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._lastProcessedKey);
        IOUtils.writeObject(out, this._error);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._lastProcessedKey = in.readLong();
        this._error = (Throwable)IOUtils.readObject(in);
    }

    public long getLastProcessedKey() {
        return this._lastProcessedKey;
    }

    public boolean hasPendingError() {
        return this.getError() != null;
    }

    public Throwable getError() {
        return this._error;
    }

    public boolean isOk() {
        return !this.hasPendingError();
    }

    public String toString() {
        return "GlobalOrderProcessStatus [getLastProcessedKey()=" + this.getLastProcessedKey() + ", hasPendingError()=" + this.hasPendingError() + ", getError()=" + this.getError() + ", isOk()=" + this.isOk() + "]";
    }
}

