/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.ReplicationBlobstoreBulkContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDeletedBacklogPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderReliableAsyncKeptDiscardedOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReplicationConsumeTimeoutException;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.AbstractGlobalOrderTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.sync.IReplicationSyncTargetProcessLog;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.LongObjectIterator;
import com.gigaspaces.internal.collections.LongObjectMap;
import com.gigaspaces.internal.utils.concurrent.ExchangeCountDownLatch;
import com.j_spaces.core.exception.ClosedResourceException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@InternalApi
public class GlobalOrderTargetProcessLog
extends AbstractGlobalOrderTargetProcessLog
implements IReplicationSyncTargetProcessLog,
IReplicationAsyncTargetProcessLog {
    private final SortedSet<IReplicationOrderedPacket> _packetsQueue;
    private final LongObjectMap<ExchangeCountDownLatch<Throwable>> _pendingPackets = CollectionsFactory.getInstance().createLongObjectMap();
    private final long _consumeTimeout;

    public GlobalOrderTargetProcessLog(GlobalOrderProcessLogConfig processLogConfig, IReplicationPacketDataConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, boolean oneWayProcessing, IReplicationGroupHistory groupHistory) {
        this(processLogConfig, dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, -1L, true, oneWayProcessing, groupHistory);
    }

    public GlobalOrderTargetProcessLog(GlobalOrderProcessLogConfig processLogConfig, IReplicationPacketDataConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, long lastProcessedKey, boolean isFirstHandshake, boolean oneWayProcessing, IReplicationGroupHistory groupHistory) {
        super(dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, lastProcessedKey, isFirstHandshake, groupHistory);
        this._consumeTimeout = processLogConfig.getConsumeTimeout();
        this._packetsQueue = new TreeSet<IReplicationOrderedPacket>(new SharedOrderedPacketComparator());
    }

    @Override
    protected boolean contentRequiredWhileProcessing() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalOrderProcessResult processBatch(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback filterInCallback) {
        if (!this.isOpen()) {
            this.throwClosedException();
        }
        boolean processedPacket = false;
        ExchangeCountDownLatch<Throwable> latch = null;
        this._lock.lock();
        try {
            Throwable errorDuringAfterConsumption;
            if (this.isClosed()) {
                this.throwClosedException();
            }
            this.filterDuplicate(packets);
            if (packets.isEmpty()) {
                GlobalOrderProcessResult globalOrderProcessResult = GlobalOrderProcessResult.OK;
                return globalOrderProcessResult;
            }
            this._packetsQueue.addAll(packets);
            long myLastKey = packets.get(packets.size() - 1).getKey();
            try {
                processedPacket = this.processPackets(sourceLookupName, myLastKey, filterInCallback);
                errorDuringAfterConsumption = this.afterConsumption(processedPacket, this._lastProcessedKey);
            }
            catch (Throwable t) {
                try {
                    GlobalOrderProcessResult globalOrderProcessResult = this.onErrorReleasePendingAndReturnResult(t);
                    this._lock.unlock();
                    return globalOrderProcessResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Throwable errorDuringAfterConsumption2 = this.afterConsumption(processedPacket, this._lastProcessedKey);
                }
            }
            if (!processedPacket) {
                latch = this.addPendingPacketLock(myLastKey);
            }
            if (errorDuringAfterConsumption != null) {
                GlobalOrderProcessResult globalOrderProcessResult = new GlobalOrderProcessResult(errorDuringAfterConsumption, this.calcLastProcessedkey());
                return globalOrderProcessResult;
            }
        }
        finally {
            this._lock.unlock();
        }
        return this.afterProcessAttempt(processedPacket, latch);
    }

    private long calcLastProcessedkey() {
        ReplicationInContext replicationInContext = this.getReplicationInContext();
        ReplicationBlobstoreBulkContext replicationBlobstoreBulkContext = replicationInContext.getReplicationBlobstoreBulkContext();
        if (replicationBlobstoreBulkContext != null && replicationBlobstoreBulkContext.getBlobStoreReplicationBulkConsumeHelper() != null) {
            return replicationBlobstoreBulkContext.getBlobStoreReplicationBulkConsumeHelper().getLastProcessedKey();
        }
        return this._lastProcessedKey;
    }

    private GlobalOrderProcessResult afterProcessAttempt(boolean processedPacket, ExchangeCountDownLatch<Throwable> latch) {
        if (processedPacket) {
            return GlobalOrderProcessResult.OK;
        }
        try {
            if (!latch.await(this._consumeTimeout, TimeUnit.MILLISECONDS)) {
                return new GlobalOrderProcessResult(new ReplicationConsumeTimeoutException("Timeout exceeded [" + this._consumeTimeout + "ms] while waiting for packet to be consumed"), this.calcLastProcessedkey());
            }
            Throwable error = latch.get();
            if (error == null) {
                return GlobalOrderProcessResult.OK;
            }
            this.rethrowAsClosedIfNeeded(error);
            return new GlobalOrderProcessResult(error, this.calcLastProcessedkey());
        }
        catch (InterruptedException e) {
            return new GlobalOrderProcessResult(e, this.calcLastProcessedkey());
        }
    }

    private Throwable afterConsumption(boolean successful, long lastProcessedKey) {
        try {
            this.getReplicationInFacade().afterConsumption(this.getReplicationInContext(), successful, lastProcessedKey);
            return null;
        }
        catch (Throwable ex) {
            long possibleRevertedKey;
            if (this._specificLogger.isLoggable(Level.SEVERE)) {
                this._specificLogger.log(Level.SEVERE, "failure during after consumption", ex);
            }
            if ((possibleRevertedKey = this.calcLastProcessedkey()) != this._lastProcessedKey) {
                if (this._specificLogger.isLoggable(Level.SEVERE)) {
                    this._specificLogger.log(Level.SEVERE, "reverting last processed redo key from: " + this._lastProcessedKey + " to " + possibleRevertedKey, ex);
                }
                this._lastProcessedKey = possibleRevertedKey;
            }
            return ex;
        }
    }

    private void rethrowAsClosedIfNeeded(Throwable error) {
        if (error instanceof ClosedResourceException) {
            throw (ClosedResourceException)error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalOrderProcessResult process(String sourceLookupName, IReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback) {
        if (!this.isOpen()) {
            this.throwClosedException();
        }
        ExchangeCountDownLatch<Throwable> latch = null;
        this._lock.lock();
        try {
            Throwable errorDuringAfterConsumption;
            long myLastKey;
            block17: {
                if (this.isClosed()) {
                    this.throwClosedException();
                }
                if (this.filterDuplicate(packet)) {
                    GlobalOrderProcessResult globalOrderProcessResult = GlobalOrderProcessResult.OK;
                    return globalOrderProcessResult;
                }
                myLastKey = packet.getKey();
                if (myLastKey != this._lastProcessedKey + 1L) break block17;
                this.processPacket(sourceLookupName, inFilterCallback, this.getReplicationInContext(), packet, true);
                if (!this._packetsQueue.isEmpty()) {
                    this.processPackets(sourceLookupName, myLastKey, inFilterCallback);
                }
                GlobalOrderProcessResult globalOrderProcessResult = GlobalOrderProcessResult.OK;
                Throwable errorDuringAfterConsumption2 = this.afterConsumption(false, this._lastProcessedKey);
                return globalOrderProcessResult;
            }
            try {
                this._packetsQueue.add(packet);
                latch = this.addPendingPacketLock(myLastKey);
                errorDuringAfterConsumption = this.afterConsumption(false, this._lastProcessedKey);
            }
            catch (Throwable t) {
                try {
                    GlobalOrderProcessResult globalOrderProcessResult = this.onErrorReleasePendingAndReturnResult(t);
                    this._lock.unlock();
                    return globalOrderProcessResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Throwable errorDuringAfterConsumption3 = this.afterConsumption(false, this._lastProcessedKey);
                }
            }
            if (errorDuringAfterConsumption != null) {
                GlobalOrderProcessResult globalOrderProcessResult = new GlobalOrderProcessResult(errorDuringAfterConsumption, this.calcLastProcessedkey());
                return globalOrderProcessResult;
            }
        }
        finally {
            this._lock.unlock();
        }
        return this.afterProcessAttempt(false, latch);
    }

    private ExchangeCountDownLatch<Throwable> addPendingPacketLock(long key) {
        ExchangeCountDownLatch<Throwable> latch = new ExchangeCountDownLatch<Throwable>();
        this._pendingPackets.put(key, latch);
        return latch;
    }

    protected boolean processPackets(String sourceLookupName, long myLastKey, IReplicationInFilterCallback filterInCallback) throws Exception {
        Iterator iterator = this._packetsQueue.iterator();
        while (iterator.hasNext()) {
            IReplicationOrderedPacket packet = (IReplicationOrderedPacket)iterator.next();
            if (packet.getKey() > this._lastProcessedKey + 1L) {
                return this._lastProcessedKey >= myLastKey;
            }
            if (packet.getKey() == this._lastProcessedKey + 1L) {
                this.processPacket(sourceLookupName, filterInCallback, this.getReplicationInContext(), packet, true);
            }
            iterator.remove();
            ExchangeCountDownLatch<Throwable> latch = this._pendingPackets.remove(packet.getKey());
            if (latch == null) continue;
            latch.countDown(null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(String sourceLookupName, IReplicationInFilterCallback filterInCallback, ReplicationInContext context, IReplicationOrderedPacket packet, boolean throwOnClosed) throws Exception {
        if (this.preprocess(packet)) {
            context.setContextPacket(packet);
            context.setLastProcessedKey(this._lastProcessedKey);
            try {
                IReplicationPacketData<?> data = packet.getData();
                if (filterInCallback != null && this.shouldCloneOnFilter()) {
                    data = data.clone();
                }
                IDataConsumeResult prevResult = null;
                while (true) {
                    if (throwOnClosed && this.isClosed()) {
                        throw new ClosedResourceException("Process log is closed");
                    }
                    IDataConsumeResult consumeResult = this.getDataConsumer().consume(context, data, this.getReplicationInFacade(), filterInCallback);
                    if (!consumeResult.isFailed()) break;
                    GlobalOrderTargetProcessLog.throwIfRepetitiveError(prevResult, consumeResult);
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.log(Level.FINER, "Encountered error while consuming packet [" + packet + "], trying to resolve issue", consumeResult.toException());
                    }
                    IDataConsumeFix fix = this.getExceptionHandler().handleException(consumeResult, packet);
                    data = this.getDataConsumer().applyFix(context, data, fix);
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.log(Level.FINER, "Fix applied - retrying the operation [" + fix + "]");
                    }
                    prevResult = consumeResult;
                }
                ++this._lastProcessedKey;
            }
            finally {
                context.setContextPacket(null);
            }
        }
        this.afterSuccessfulConsumption(sourceLookupName, packet);
    }

    protected void afterSuccessfulConsumption(String sourceLookupName, IReplicationOrderedPacket packet) {
    }

    protected boolean shouldCloneOnFilter() {
        return false;
    }

    private boolean preprocess(IReplicationOrderedPacket packet) {
        if (packet.isDataPacket()) {
            return true;
        }
        if (packet instanceof GlobalOrderDeletedBacklogPacket) {
            GlobalOrderDeletedBacklogPacket deletedBacklogPacket = (GlobalOrderDeletedBacklogPacket)packet;
            this.logDeletion(deletedBacklogPacket);
            this._lastProcessedKey = deletedBacklogPacket.getEndKey();
            return false;
        }
        if (packet instanceof GlobalOrderDiscardedReplicationPacket) {
            this._lastProcessedKey = ((GlobalOrderDiscardedReplicationPacket)packet).getEndKey();
            return false;
        }
        if (packet instanceof GlobalOrderReliableAsyncKeptDiscardedOrderedPacket) {
            this._lastProcessedKey = packet.getEndKey();
            return false;
        }
        return true;
    }

    @Override
    protected String dumpStateExtra() {
        this._lock.lock();
        try {
            if (this._packetsQueue.isEmpty()) {
                String string = "EMPTY";
                return string;
            }
            IReplicationOrderedPacket first = this._packetsQueue.first();
            String string = "pending packets [" + this._packetsQueue.size() + "], first packet [" + first.toString() + "]";
            return string;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    protected void onClose() {
        this.releasePendingWithError(new ClosedResourceException("Process log is closed"));
    }

    private GlobalOrderProcessResult onErrorReleasePendingAndReturnResult(Throwable error) {
        this.releasePendingWithError(error);
        this.rethrowAsClosedIfNeeded(error);
        Level level = this.getLogLevel(error);
        if (this._specificLogger.isLoggable(level)) {
            this._specificLogger.log(level, "error while processing incoming replication", error);
        }
        GlobalOrderProcessResult result = new GlobalOrderProcessResult(error, this.calcLastProcessedkey());
        return result;
    }

    private void releasePendingWithError(Throwable error) {
        LongObjectIterator<ExchangeCountDownLatch<Throwable>> iterator = this._pendingPackets.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            iterator.value().countDown(error);
        }
        this._pendingPackets.clear();
    }

    public static class SharedOrderedPacketComparator
    implements Comparator<IReplicationOrderedPacket> {
        @Override
        public int compare(IReplicationOrderedPacket o1, IReplicationOrderedPacket o2) {
            return o1.getKey() < o2.getKey() ? -1 : (o1.getKey() == o2.getKey() ? 0 : 1);
        }
    }
}

